% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEP_FIM.R
\name{SEP_FIM}
\alias{SEP_FIM}
\title{Fisher-Shannon method}
\usage{
SEP_FIM(x, h, log_trsf=FALSE, resol=1000, tol = .Machine$double.eps)
}
\arguments{
\item{x}{Univariate data.}

\item{h}{Value of the bandwidth for the density estimate}

\item{log_trsf}{Logical flag: if \code{TRUE} the data are log-transformed (used for skewed data), in this case
the data should be positive. By default, \code{log_trsf = FALSE}.}

\item{resol}{Number of equally-spaced points, over which function approximations are computed and integrated.}

\item{tol}{A tolerance to avoid dividing by zero values.}
}
\value{
A table with one row containing:
 \itemize{
  \item \code{SEP} Shannon Entropy Power.
  \item \code{FIM} Fisher Information Measure.
  \item \code{FSC} Fisher-Shannon Complexity
  }
}
\description{
Non-parametric estimates of the Shannon Entropy Power (SEP), the Fisher Information Measure (FIM) and the
Fisher-Shannon Complexity (FSC), using kernel density estimators with Gaussian kernel.
}
\examples{

library(KernSmooth)
x <- rnorm(1000)
h <- dpik(x)
SEP_FIM(x, h)



}
\references{
F. Guignard, M. Laib, F. Amato, M. Kanevski, Advanced analysis of temporal
data using Fisher-Shannon information: theoretical development and application
in geosciences, \href{https://arxiv.org/abs/1912.02452}{arXiv:1912.02452}.
}
