% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovariateData.R
\name{loadCovariateData}
\alias{loadCovariateData}
\title{Load the covariate data from a folder}
\usage{
loadCovariateData(file, readOnly)
}
\arguments{
\item{file}{The name of the folder containing the data.}

\item{readOnly}{DEPRECATED: If true, the data is opened read only.}
}
\value{
An object of class \code{CovariateData}.
}
\description{
\code{loadCovariateData} loads an object of type covariateData from a folder in the file system.
}
\details{
The data will be written to a set of files in the folder specified by the user.
}
\examples{
\donttest{
andromedaVersion <- utils::packageVersion("Andromeda")
if (andromedaVersion < "1.0.0") {
  binaryCovDataFile <- system.file("testdata/binaryCovariateData.zip",
    package = "FeatureExtraction"
  )
} else {
  binaryCovDataFile <- system.file("testdata/binaryCovariateDataDuckDB.zip",
    package = "FeatureExtraction"
  )
}
covData <- loadCovariateData(binaryCovDataFile)
}

}
