% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_data.R
\name{elevate}
\alias{elevate}
\title{Elevate}
\usage{
elevate(X, e = NULL)
}
\arguments{
\item{X}{The prices.}

\item{e}{numeric. The focal point of the hyperbola.}
}
\description{
A transformation to turn negative prices into positive prices
and maintain at the same time the hierachy between all prices.
}
\details{
Negative prices in financial markets, like interest rates in Europe, are a 
nightmare as the rough calculation of the returns generates non-sense values.
\code{elevate} uses an hyperbola and implements the following formula: 
     \deqn{ elevate(x, e) = (x + sqrt(x*x + e*e)) / 2 }

There is currently no rule of thumb to calculate \code{e}. 
When \eqn{e = NULL}, there is no change and the output is identical to the input.
When \eqn{e = 0}, all negative values are turned to 0.
}
\examples{
   
require(graphics)

X <- (-50:100)/5
plot( X, elevate(X, e = 5), type = "l", ylim = c(0, 20) )
lines(X, elevate(X, e = 2),   col = 2)
lines(X, elevate(X, e = 1),   col = 3)
lines(X, elevate(X, e = 0.5), col = 4)
lines(X, elevate(X, e = 0),   col = 1)

}

