% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kin_long.R
\name{Kin_long}
\alias{Kin_long}
\title{Converts a list vector of kin into a dataframe of kin}
\usage{
Kin_long(idkin)
}
\arguments{
\item{idkin}{List vector of kin}
}
\value{
Dataframe of kin (long format)
}
\description{
Converts a list vector of kin into a dataframe of kin. The dataframe has a "long format", 
i.e. it has one row for each ego-kin dyad.
}
\examples{
# Load data
data(dLH,package="Families")
# IDs of ego and their grandchildren
idego <- dLH$ID[dLH$gen==1]
# IDs of grandchildren of ego 
idgch <- lapply(idego,function(x) IDch(IDch(x)))
names(idgch) <- idego
# Dataframe with ID of grandmother and grandchild
dfgch <- Kin_long(idkin=idgch)[,1:2]

}
