\name{carrierprob}
\alias{carrierprob}
\title{
Compute mutation carrier probabilities for individuals with missing gentoypes
%conditional on observed phenotypes and genotypes 
}
\description{
This function computes model- or data-based carrier probabilities for individuals with missing genotypes based on the observed mutation status of family members and the individual's phenotype.
}
\usage{
carrierprob(condition="geno", method="data",fit=NULL, data, mode="dominant", q=0.02)
}
\arguments{
 \item{condition}{
 Choice of conditional information to use for computing the carrier probability. Possible choices are \code{"geno"} for using observed genotypes and \code{"geno+pheno"} for using both observed genotype and phenotype information in the calculation of the carrier probability.
 }
 \item{method}{
Choice of methods to calculate the carrier probability. Possible choices are \code{"data"} for empirical calculation of the carrier probabilities based on data or \code{"model"} using the parametric model fit; see details. 
 Default is \code{"data"}.
 If \code{method="data"}, only \code{data} is required to be specified.  
}

\item{fit}{
An object of class \code{penmodel}, a fitted model by \code{penmodelEM} function for inferring missing mutation status in the family.
}
\item{data}{
Family data that includes missing genotypes using the same data format generated by the function \code{simfam}.
}

\item{mode}{
Choice of modes of inheritance when using \code{method="model"}. Possible choices are \code{"dominant"} for dominant model or \code{"recessive"} for recessive model. Default is \code{"dominant"}.
}

 \item{q}{
The frequency of the disease causing allele when using \code{method="model"}. The value should be between 0 and 1. If \code{NULL}, the estimated allele frequency from data will be used. Default value  is \code{0.02}.
}
}
\details{
When \code{method="model"} along with the choice of \code{condition="geno+pheno"},
the carrier probability for individual \eqn{i} is calculated by conditioning on her/his observed phenotype and carrier statuses of family members 
\deqn{ P(X_i = 1 | Y_i, X^o ) = \frac{P(Y_i | X_i=1) P(X_i=1|X^o)}{P(Y_i | X_i=1) P(X_i=1|X^o) + P(Y_i| X_i=0) P(X_i=0|X^o)},  }
where \eqn{X_i} indicates the unknown carrier status of individual \eqn{i} and \eqn{X^o} represents the observed carrier statuses in his or her family members; \eqn{Y_i} represents the observed phenotype \eqn{(t_i, \delta_i)}  of individual \eqn{i} in terms of age at onset \eqn{t_i} and disease status indicator \eqn{\delta_i} with 1 used for affected individuals and 0 for unaffected individuals. 

When \code{method="model"} along with the choice of \code{condition="geno"}, the carrier probability is calculated based on Mendelian laws of genetic transmission with a fixed allele frequency.

}
\value{
Returns a data frame with a vector of carrier probabilities called \code{carrp.geno} when \code{condition="geno"} or \code{carrp.pheno} when \code{condtion="geno+pheno"} added after the last column of the family data.
}
\author{
Yun-Hee Choi
}
\seealso{
\code{\link{simfam}, \link{penmodelEM}, \link{plot.simfam}}
}
\examples{

# Simulated family data with 30\% of members missing their genetic information.

fam <- simfam(N.fam=100, design="pop+", base.dist="Weibull", mrate=0.3,
       base.parms=c(0.01,3), vbeta=c(-1.13, 2.35), agemin=20)
 
# EM algorithm for fitting family data with missing genotypes assuming a Weibull
# baseline hazard and dominant mode of Mendelian inheritance for a major gene.

fitEM <- penmodelEM(parms=c(0.01, 3), vbeta=c(-1.13, 2.35), data=fam, design="pop+",
       base.dist="Weibull", method="mendelian", mode="dominant")

# Carrier probability obtained by conditioning on the observed genotypes and phenotype, 
# assuming a dominant Mendelian mode of inheritance

fam.added <- carrierprob(condition="geno+pheno", method="model", fit=fitEM, data=fam, 
             mode="dominant", q=0.02)

# pedigree plot for family 1 displaying carrier probabilities

plot.simfam(fam.added, famid=1)

}
\keyword{Carrier probability}
