\name{run.cluster.matrix}
\alias{run.cluster.matrix}
\title{Identify Equivalent Peaks from Different Subjects}
\description{
Takes the file generated by \code{\link{run.lrg.peaks}}, identifies equivalent peaks in each spectrum,
and fills in missing values.
}
\usage{
run.cluster.matrix(pre.align = FALSE, align.method = "spline", 
                   trans.method = "shiftedlog", add.par = 10,
                   lrg.only = TRUE, masses = NULL, isotope.dist = 7,
                   root.dir = ".", base.dir, peak.dir, lrg.dir, 
                   lrg.file = "lrg.peaks.RData", overwrite = FALSE,
                   use.par.file = FALSE, par.file = "parameters.RData")
}
\arguments{
  \item{pre.align}{either \code{FALSE}, or a numeric vector of shifts to apply to spectra, or a two-component list
      (of the form described in the \code{Note} section below) to be used before identifying peaks from different
      spectra}
  \item{align.method}{type of alignment to use on spectra before statistical analysis; currently, only \code{"spline"}
     and \code{"none"} are supported}
  \item{trans.method}{type of transformation to use on spectra before statistical analysis; currently, only \code{"shiftedlog"},
      \code{"glog"}, and \code{"none"} are supported}
  \item{add.par}{additive parameter for \code{"shiftedlog"} or \code{"glog"} options for \code{trans.method}}
  \item{lrg.only}{whether to consider only peaks that have at least one peak \dQuote{significant}; i.e.,
      identified by \code{run.lrg.peaks}}
  \item{masses}{numeric vector of specific masses to test}
  \item{isotope.dist}{maximum number of isotope peaks to look at (in addition to main peak)}
  \item{root.dir}{string containing location of raw data directory}
  \item{base.dir}{directory for baseline-corrected files; default is \code{paste(root.dir, "/Baseline_Corrected", sep = "")}}
  \item{peak.dir}{directory for peak location files; default is \code{paste(root.dir, "/All_Peaks", sep = "")}}
  \item{lrg.dir}{directory for significant peaks file; default is \code{paste(root.dir, "/Large_Peaks", sep = "")}}
  \item{lrg.file}{string containing name of significant peaks file}
  \item{overwrite}{logical; whether to replace existing files with new ones}
  \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from 
      \code{par.file} in directory \code{root.dir}}
  \item{par.file}{string containing name of parameters file}
}
\details{Reads in information from file created by \code{\link{run.strong.peaks}}, calculates the cluster matrix,
fills in missing values, and overwrites the file named \code{lrg.file} in \code{lrg.dir}.  
The resulting file contains variables
\tabular{ll}{ \tab \cr
    \code{amps}\tab data frame of amplitudes created by \code{\link{run.strong.peaks}}\cr
    \code{centers}\tab data frame of centers created by \code{\link{run.strong.peaks}}\cr
    \code{clust.mat}\tab data frame with columns given by samples and rows given by the distinct peaks in the samples\cr
    \code{num.sig}\tab vector of the number of peaks in each row of \code{clust.mat} which were not missing\cr
    \code{lrg.peaks}\tab the data frame of significant peaks created by \code{\link{run.lrg.peaks}}\cr
}
    and is ready to be used by \code{\link{run.strong.peaks}}.
}
\value{
No value returned; the file is simply created.
}
\references{
Barkauskas, D.A. \emph{et al}. (2008) \dQuote{Detecting glycan cancer biomarkers in serum 
samples using MALDI FT-ICR mass spectrometry data}.  Submitted to \emph{Bioinformatics}
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{If \code{use.par.file = TRUE}, then the parameters read in from the file overwrite any arguments entered in the
function call.

\code{pre.align} is used if the spectra have not already been aligned by the mass spectroscopists.
If it is not \code{FALSE}, it can either be a vector of additive shifts to be applied to the 
spectra, or a list with components \code{targets} and \code{actual}.  In the last case, \code{targets}
is a vector of target masses, and \code{actual} is a matrix with \code{length(targets)}
columns and a row for each spectrum, \code{actual[i,j]} being the mass in spectrum \code{i} that should  
be matched exactly to \code{target[j]}, with \code{NA} being a valid entry in \code{actual}.  
The matching is done (depending on the number of non-missing values in row \code{i}) either with a
simple shift (one non-missing value), an affine transformation (two non-missing values), a 
piecewise affine transformation (three non-missing values), or an interpolation spline (four 
or more non-missing values).
}
\seealso{\code{\link{run.lrg.peaks}}, \code{\link{run.strong.peaks}}, \code{\link[splines]{interpSpline}}}
\examples{}