% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{gainRatio}
\alias{gainRatio}
\title{The gain ratio measure}
\usage{
gainRatio()
}
\value{
Returns a function that is used to generate an evaluation set measure using the gain ratio value for the selected features.
}
\description{
Generates an evaluation function that calculates the gain ratio value \insertCite{Quinlan1986}{FSinR}, using the information theory (set measure). This function is called internally within the \code{\link{filterEvaluator}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# A discrete dataset is used (in this case we use only several discrete columns)
adult <- adult[,c(4,9,10,15)]

# Generate the evaluation function with Cramer
gr_evaluator <- gainRatio()
# Evaluate the features (parameters: dataset, target variable and features)
gr_evaluator(adult,'income',c('race','sex','education'))
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez
}
