% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{fishR}
\alias{fishR}
\title{Opens web pages associated with the fishR website.}
\usage{
fishR(
  where = c("home", "posts", "books", "IFAR", "AIFFD", "packages", "data", "teaching"),
  open = TRUE
)
}
\arguments{
\item{where}{A string that indicates a particular page on the fishR website to open.}

\item{open}{A logical that indicates whether the webpage should be opened in the default browser. Defaults to \code{TRUE}; \code{FALSE} is used for unit testing.}
}
\value{
None, but a webpage will be opened in the default browser.
}
\description{
Opens web pages associated with the \href{https://fishr-core-team.github.io/fishR/}{fishR website} in a browser. The user can open the main page or choose a specific page to open.
}
\examples{
\dontrun{
## Opens an external webpage ... only run interactively
fishR()            # home page
fishR("posts")     # blog posts (some examples) page
fishR("books")     # examples page
fishR("IFAR")      # Introduction to Fisheries Analysis with R page
fishR("AIFFD")     # Analysis & Interpretation of Freshw. Fisher. Data page
fishR("packages")  # list of r-related fisheries packages
fishR("data")      # list of fisheries data sets
fishR("teaching")  # teaching resources
}

}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
\keyword{misc}
