% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dsvd.R
\name{Dsvd}
\alias{Dsvd}
\title{Distributed svd}
\usage{
Dsvd(data,K, nk,k)
}
\arguments{
\item{data}{a real input matrix (or data frame) to be decomposed.}

\item{K}{the number of blocks into which variable X is divided.}

\item{nk}{The number of each blocks.}

\item{k}{the desired target rank.}
}
\value{
MSE of Xs,vsvd,Ssvd and kopt.
}
\description{
Distributed svd
}
\examples{
library(matrixcalc)
K=20; nk=50; nr=10; p=8; k=4; n=K*nk;
data=matrix(c(rnorm((n-nr)*p,0,1),rpois(nr*p,100)),ncol=p)
Dsvd(data=data,K=K, nk=nk,k=k)
}
