% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{set_cache_folder}
\alias{set_cache_folder}
\title{Set (change) HuggingFace cache folder temporarily.}
\usage{
set_cache_folder(path = NULL)
}
\arguments{
\item{path}{Folder path to store HuggingFace models. If \code{NULL}, then return the current cache folder.}
}
\description{
This function allows you to change the default cache directory (when it lacks storage space) to another path (e.g., your portable SSD) \emph{temporarily}.
}
\section{Keep in Mind}{
This function takes effect only for the current R session \emph{temporarily}, so you should run this each time BEFORE you use other FMAT functions in an R session.
}

\examples{
\dontrun{
library(FMAT)
set_cache_folder("D:/huggingface_cache/")
# -> models would be saved to "D:/huggingface_cache/hub/"
# run this function each time before using FMAT functions

BERT_download()
BERT_info()
}

}
