% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_info}
\alias{BERT_info}
\title{Get basic information of BERT models.}
\usage{
BERT_info(models = NULL)
}
\arguments{
\item{models}{A character vector of model names at
\href{https://huggingface.co/models}{HuggingFace}.}
}
\value{
A data.table:
\itemize{
\item model name
\item model type
\item number of parameters
\item vocabulary size (of input token embeddings)
\item embedding dimensions (of input token embeddings)
\item hidden layers
\item attention heads
\item [MASK] token
}
}
\description{
Get basic information of BERT models.
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_info(models)

BERT_info()  # information of all downloaded models
# speed: ~1.2s/model for first use; <1s afterwards
}

}
\seealso{
\code{\link[=BERT_download]{BERT_download()}}

\code{\link[=BERT_vocab]{BERT_vocab()}}
}
