% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_apply.R
\name{fftrees_apply}
\alias{fftrees_apply}
\title{Apply an FFT to data and generate accuracy statistics}
\usage{
fftrees_apply(x, mydata = NULL, newdata = NULL, allNA.pred = FALSE)
}
\arguments{
\item{x}{An object with FFT definitions which are to be applied to current data (as an \code{FFTrees} object).}

\item{mydata}{The type of data to which the FFT should be applied (as character, either \code{"train"} or \code{"test"}).}

\item{newdata}{New data to which an FFT should be applied (as a data frame).}

\item{allNA.pred}{What should be predicted if all cue values in tree are \code{NA} (as logical)?
Default: \code{allNA.pred = FALSE}.}
}
\value{
A modified \code{FFTrees} object (with lists in \code{x$trees} containing information on FFT decisions and statistics).
}
\description{
\code{fftrees_apply} applies a fast-and-frugal tree (FFT, as an \code{FFTrees} object)
to a dataset (of type \code{mydata}) and generates corresponding accuracy statistics
(on cue levels and for trees).

\code{fftrees_apply} is called internally by the main \code{\link{FFTrees}} function
(with \code{mydata = "train"} and --- if test data exists --- \code{mydata = "test"}).
Alternatively, \code{fftrees_apply} is called when predicting outcomes for new data
by \code{\link{predict.FFTrees}}.
}
\seealso{
\code{\link{FFTrees}} for creating FFTs from and applying them to data.
}
\keyword{internal}
