% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{getFE}
\alias{getFE}
\title{Extract the Fixed-Effects from a \code{femlm} estimation.}
\usage{
getFE(x)
}
\arguments{
\item{x}{A \code{\link[FENmlm]{femlm}} object.

If the cluster coefficients not regular, then several reference points need to be set, leading to the coefficients to be NOT interpretable. If this is the case, then a warning is raised.}
}
\value{
A list containig the vectors of the fixed effects.

If there is more than 1 cluster, then the attribute \dQuote{References} is created. This is a vector of length the number of clusters, each element contains the number of fixed-effects set as references. By construction, the elements of the first clusters are never set as references. In the presence of regular clusters, there should be Q-1 references (with Q the number of clusters).
}
\description{
This function retrives the fixed effects from a femlm estimation. It is useful only when there are more than one cluster.
}
\examples{

data(trade)

# We estimate the effect of distance on trade => we account for 3 cluster effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# obtaining the cluster coefficients
fe_trade = getFE(est_pois)

# plotting them
plot(fe_trade)

# plotting only the Products fixed-effects & showing more of them
plot(fe_trade$Product, n=8)

}
\seealso{
See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
