% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{rejection.path}
\alias{rejection.path}
\title{Rejection Path Plot (for \code{FDX} objects)}
\usage{
rejection.path(
  x,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  xlab = expression(zeta),
  ylab = "Number of Rejections",
  verticals = FALSE,
  pch = 19,
  ref.show = FALSE,
  ref.col = "gray",
  ref.lty = 2,
  ref.lwd = 2,
  ...
)
}
\arguments{
\item{x}{an object of class "\code{FDX}".}

\item{xlim}{the x limits of the plot. If \code{NULL} (default),
the (0, 1) range is used.}

\item{ylim}{the y limits of the plot. If \code{NULL} (default),
the double of the median of the number of possible
rejections is used as upper limit.}

\item{main}{main title. If \code{NULL} (default), a description
string is used.}

\item{xlab, ylab}{labels for x and y axis.}

\item{verticals}{logical; if \code{TRUE}, draw vertical lines at
steps.}

\item{pch}{jump point character.}

\item{ref.show}{logical; if \code{TRUE} a vertical reference line
is plotted, whose height is the number of
rejections of the original Benjamini-Hochberg (BH)
procedure.}

\item{ref.col}{color of the reference line.}

\item{ref.lty, ref.lwd}{line type and thickness for the reference line.}

\item{...}{further arguments to \code{\link{plot.stepfun}}.}
}
\value{
Invisibly returns a \code{stepfun} object that computes the number of
rejectionsin dependence on the exceedance probability \code{zeta}.
}
\description{
Displays the number of rejections of the raw p-values in a \code{FDX}
object in dependence of the exceedance probability \code{zeta}.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports (fisher.pvalues.support
# is from 'DiscreteFDR' package!)
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

DLR <- DLR(raw.pvalues, pCDFlist)
NDLR <- NDLR(raw.pvalues, pCDFlist)

rejection.path(DLR, xlim = c(0, 1), ref.show = TRUE, ref.col = "green", ref.lty = 4)
rejection.path(NDLR, col = "red", add = TRUE)

}
