% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{glm.loglik}
\alias{glm.loglik}
\title{Log likelihood function for glm regression with a Jeffreys parameter prior and BIC approximations of the posterior
This function is created as an example of how to create an estimator that is used
to calculate the marginal likelihood of a model.}
\usage{
glm.loglik(
  y,
  x,
  model,
  complex,
  mlpost_params = list(r = exp(-0.5), family = "Gamma")
)
}
\arguments{
\item{y}{A vector containing the dependent variable}

\item{x}{The matrix containing the precalculated features}

\item{model}{The model to estimate as a logical vector}

\item{complex}{A list of complexity measures for the features}

\item{mlpost_params}{A list of parameters for the log likelihood, supplied by the user, family must be specified}
}
\value{
A list with the log marginal likelihood combined with the log prior (crit) and the posterior mode of the coefficients (coefs).
}
\description{
Log likelihood function for glm regression with a Jeffreys parameter prior and BIC approximations of the posterior
This function is created as an example of how to create an estimator that is used
to calculate the marginal likelihood of a model.
}
\examples{
glm.loglik(abs(rnorm(100))+1, matrix(rnorm(100)), TRUE, list(oc = 1))


}
