% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbms.R
\name{fbms}
\alias{fbms}
\title{Fit a BGNLM  model using Genetically Modified Mode Jumping Markov Chain Monte Carlo (MCMC) sampling.
Or Fit a BGLM model using Modified Mode Jumping Markov Chain Monte Carlo (MCMC) sampling.}
\usage{
fbms(
  formula = NULL,
  family = "gaussian",
  data = NULL,
  impute = FALSE,
  loglik.pi = gaussian.loglik,
  method = "mjmcmc",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the model structure. Default is NULL.}

\item{family}{The distribution family of the response variable. Currently supports "gaussian", "binomial" and  "custom". Default is "gaussian".}

\item{data}{A data frame containing the variables in the model. If NULL, the variables are taken from the environment of the formula. Default is NULL.}

\item{impute}{TRUE  means imputation combined with adding a dummy column with indicators of imputed values, FALSE (default) means only full data is used.}

\item{loglik.pi}{Custom function to compute the logarithm of the posterior mode based on logarithm of marginal likelihood and logarithm of prior functions (needs specification only used if family = "custom")}

\item{method}{Which fitting algorithm should be used, currently implemented options include "gmjmcmc", "gmjmcmc.parallel", "mjmcmc" and "mjmcmc.parallel" with "mjmcmc" being the default and 'mjmcmc' means that only linear models will be estimated}

\item{verbose}{If TRUE, print detailed progress information during the fitting process. Default is TRUE.}

\item{...}{Additional parameters to be passed to the underlying method.}
}
\value{
An object containing the results of the fitted model and MCMC sampling.
}
\description{
This function fits a model using the relevant MCMC sampling. The user can specify the formula,
family, data, transforms, and other parameters to customize the model.
}
\examples{
# Fit a Gaussian multivariate time series model
fbms_result <- fbms(
 X1 ~ .,
 family = "gaussian",
 method = "gmjmcmc.parallel",
 data = data.frame(matrix(rnorm(600), 100)),
 transforms = c("sin","cos"),
 P = 10,
 runs = 1,
 cores = 1
)
summary(fbms_result)
plot(fbms_result)


}
\seealso{
\code{\link{mjmcmc}}, \code{\link{gmjmcmc}}, \code{\link{gmjmcmc.parallel}}
}
