% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scenario.R
\name{create_scenario}
\alias{create_scenario}
\title{Create Stressed Scenarios}
\usage{
create_scenario(model, subsamples, data, block_ind, alpha = 0.95)
}
\arguments{
\item{model}{An object of class \code{mldfm}, containing the factor estimates.}

\item{subsamples}{A list of \code{mldfm} objects returned from \code{mldfm_subsampling}.}

\item{data}{A numeric matrix or data frame containing the time series data. Rows represent time points; columns represent observed variables.}

\item{block_ind}{A vector of integers indicating the end index of each block. Must be of length \code{blocks} and in increasing order. Required if \code{blocks > 1}.}

\item{alpha}{Numeric. Confidence level (level of stress) for the hyperellipsoid (e.g., 0.95).}
}
\value{
A list of matrices representing the hyperellipsoid points for each time observation.
}
\description{
Constructs confidence regions (hyperellipsoids) for the factor space based on a central MLDFM estimate
and a set of subsampled estimates. These regions capture estimation uncertainty and are used to simulate
stresses scenarios.
}
\examples{
\donttest{
data <- matrix(rnorm(100*300), nrow = 100, ncol = 300)
block_ind <- c(150, 300)  # Defines 3 blocks
r <- c(1, 1, 1)   # 2^2 - 1 = 4 nodes
mldfm_result <- mldfm(data, blocks = 2, block_ind = block_ind, r = r)
mldfm_subsampling_result <- mldfm_subsampling(data, blocks = 2, block_ind = block_ind, r = r, 
n_samples = 100, sample_size = 0.9)
scenario <- create_scenario(mldfm_result, mldfm_subsampling_result, data, block_ind, alpha = 0.95)
}

}
