% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eDist.R
\name{eDist}
\alias{AIC.eDist}
\alias{AICc}
\alias{AICc.eDist}
\alias{BIC}
\alias{BIC.eDist}
\alias{MDL}
\alias{MDL.eDist}
\alias{eDist}
\alias{logLik.eDist}
\alias{plot.eDist}
\alias{print.eDist}
\alias{vcov.eDist}
\title{S3 methods for manipulating eDist objects.}
\usage{
\method{logLik}{eDist}(object, ...)

\method{AIC}{eDist}(object, ..., k = 2)

AICc(object)

\method{AICc}{eDist}(object, ...)

\method{vcov}{eDist}(object, ..., corr = FALSE)

BIC(object)

\method{BIC}{eDist}(object, ...)

MDL(object)

\method{MDL}{eDist}(object, ...)

\method{print}{eDist}(x, ...)

\method{plot}{eDist}(x, ...)
}
\arguments{
\item{object,}{x An object of class eDist, usually the output of a parameter estimation function.}

\item{...}{Additional parameters}

\item{k}{numeric, The penalty per parameter to be used; the default k = 2 is the classical AIC.}

\item{corr}{logical; should vcov() return correlation matrix (instead of variance-covariance matrix).}

\item{x,}{A list to be returned as class eDist.}

\item{plot}{logical; if TRUE histogram, P-P and Q-Q plot of the distribution returned else only parameter estimation is returned.}
}
\description{
S3 methods for manipulating eDist objects
}
\note{
The MDL only works for parameter estimation by numerical maximum likelihood.
}
\examples{
X <- rnorm(20)
est.par <- eNormal(X, method ="numerical.MLE")
logLik(est.par)
AIC(est.par)
AICc(est.par)
BIC(est.par)
MDL(est.par)
vcov(est.par)
vcov(est.par,corr=TRUE)
print(est.par)
plot(est.par)
}
\author{
A. Jonathan R. Godfrey, Sarah Pirikahu, and Haizhen Wu.
}
\references{
Myung, I. (2000). The Importance of Complexity in Model Selection.
Journal of mathematical psychology, 44(1), 190-204.
}

