% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_RF.R
\name{segmentation_RF}
\alias{segmentation_RF}
\title{Image segmentation by Random Forest (Segmentacao de imagens por Random Forest).}
\usage{
segmentation_RF(im=NULL,palette,return="model",NumMax=1000,
                      col="rand",seed=NULL,norma=1,plot=TRUE)
}
\arguments{
\item{im}{:Image that will be segmented (Imagem que sera segmentada).}

\item{palette}{:Object of type dataframe or list. If it is a dataframe, the first column must be the class and the other
columns the values of the bands corresponding to each pixel. If it is list,
there must be an image in each item corresponding to each of the classes.
(Objeto do tipo dataframe ou list. Se for um dataframe a primeira coluna deve ser a classe e as demais
colunas os valores das bandas correspondentes a cada pixel. Se for list deve ter uma imagem em cada item correspondente
 a cada uma das classes).}

\item{return}{: Object indicating what will be returned by the function,
if it is "image" the segmented image will be returned,
 if it is "model" it will be the model adjusted by the Random Forest methodology
 (Objeto indicando o que sera retornado pela funcao, se for "image" sera retornado a imagem segmentada,
  se for "model" será o modelo ajustado pela metodologia Random Forest).}

\item{NumMax}{: Maximum number of pixels of each class to be considered when adjusting
the Random Forest methodology (Número máximo de pixels de cada classe a serem
considerados no ajuste da metodologia Random Forest).}

\item{col}{: Vector with the desired colors in the segmentation. If it's "rand" it will be random colors
(Vetor com as cores desejadas na segmentacao. Se for "rand" serao cores aleatorias).}

\item{seed}{is an integer vector, containing the random number generator (RNG) state for random number generation in R
(E um vetor com numero inteiros para a geração de valores aleatorios)}

\item{norma}{Number by which pixel values should be divided to vary between 0 and 1 (Numero pelo qual os valores dos pixels deverao ser divididos para variar entre 0 e 1)}

\item{plot}{: Logical value, if TRUE, the image will be displayed
(Valor logico, se for TRUE a imagem sera apresentada).}
}
\value{
Returns the segmented image (Retorna a imagem segmentada).
}
\description{
This function fits a Random Forest model for image segmentation
(Esta funcao ajusta um modelo Random Forest para a segmentacao de imagens).
}
\examples{

\donttest{
#Carregando imagens de exemplo
end=example_image(13)
im=read_image(end,plot=TRUE)
seg1=clustering_Kmeans(im,bands = "all",ncluster = 2,col = c("green","red"))
seg2=clustering_Kmeans(im,bands = c(1,2,3),ncluster = 3,col = c("green","red","blue"))
seg3=clustering_Kmeans(im,bands = c(1,2,3),ncluster = 4,col = "rand")
im=read_image(example_image(3))
Fundo=read_image(example_image(4))
Folha=read_image(example_image(5))
Ref=read_image(example_image(6))
paleta=list(Fundo=Fundo,Folha=Folha,Referencia=Ref)
col=c("black","green","red")

#### Criando imagem
Image=segmentation_RF(im=im,
                      palette=paleta,
                      return="image",
                      NumMax=1000,
                      col=col,
                      seed=NULL,
                      norma=1,
                      plot=TRUE)


#Criando um modelo
model=segmentation_RF(im=im,
palette=paleta,
return="model",
NumMax=1000,
col=col,
seed=NULL,
norma=1,
plot=FALSE)


image=predict_RF(im,model,col="rand",plot=TRUE)

# Outra forma de criar a paleta de cores
pallete2=rbind(
cbind(Class="Fundo",linearize_image(Fundo)[,-c(1,2)]),
cbind(Class="Folha",linearize_image(Folha)[,-c(1,2)]),
cbind(Class="Referencia",linearize_image(Ref)[,-c(1,2)]))
Image=segmentation_RF(im=im,
                      palette=pallete2,
                      return="image",
                      NumMax=1000,
                      col="rand",
                      seed=NULL,
                      norma=1,
                      plot=TRUE)



}
}
\seealso{
\code{\link{predict_RF}} , \code{\link{segmentation_logit}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
