% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude_object.R
\name{exclude_object}
\alias{exclude_object}
\title{Exlude objects in an image by encircling them  or using a mask (Excluir objetos em uma imagem circundado-os ou usando uma mascara).}
\usage{
exclude_object(im,mask=NULL,valueTarget = 0,color=c(r=1,g=1,b=1),plot=TRUE)
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{mask}{: Object with the masks of the object of interest, can be obtained by
the segmentation function, if it is NULL the object can be circled by clicking on the plot
 (Objeto com as mascaras do objeto de interesse, pode ser obtido
 pela funcao segmentation, se for NULL o objeto podera ser circundado clicando sobre o plot).}

\item{valueTarget}{:Value corresponding to the mask pixels corresponding to the objects of interest
(Valor correspondentes aos pixels da mascara correspondentes aos objetos de interesse).}

\item{color}{: Vector with R, G and B values that will replace object pixels
(Vetor com valores de R, G e B que substituirao os pixels dos objetos).}

\item{plot}{: Logical value, if TRUE the image will be plotted (Valor logico, se for TRUE a imagem sera plotada).}
}
\value{
Returns an image with pixel values equal to 1(white) for the foreground and 0 (black)
 for the foreground (Retorna uma imagem com valores de pixel igual a 1( branco) para o foreground
  e 0 (preto) para o foreground).
}
\description{
The function excludes objects by encircling them or using a mask.
(A funcao exclui objetos circundando-os ou usando uma mascara).
}
\examples{

# Abrindo a imagem
im=read_image(example_image(3),plot=TRUE)

#Obtendo a escalad e cinza
m=gray_scale(im,method = "r/rgb",plot=TRUE)

#Obtendo a mascara
seg=segmentation(m,treshold = 0.50,selectHigher = TRUE,fillHull = TRUE,plot=TRUE)

#Excluindo o objeto
exclude_object(im,mask=seg,valueTarget = 0,color=c(r=0.95,g=0.94,b=0.94))

#dilatando o objeto e excluindo-o
seg2=dilate_image(seg,n=5)
exclude_object(im,mask=seg2,valueTarget = 0,color=c(r=0.95,g=0.94,b=0.94))


exclude_object(im,mask=seg2,valueTarget = 1,color=c(r=0.95,g=0.94,b=0.94))

\dontrun{
 # Segmentar e excluir clicando sobre a imagem.
exclude_object(im,valueTarget = 1,color=c(r=0.95,g=0.94,b=0.94))
}
}
\seealso{
\code{\link{segmentation}} , \code{\link{segmentation_logit}}, \code{\link{segmentation_logitGUI}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
