% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.R
\name{levene}
\alias{levene}
\title{Test for homogeneity of variances of Levene}
\usage{
levene(trat, resp, t, r)
}
\arguments{
\item{trat}{Numeric or complex vector containing treatments.}

\item{resp}{Numeric or complex vector containing the response
variable.}

\item{t}{Number of treatments.}

\item{r}{Numeric or complex vector containing the number of
replications of each treatment.}
}
\value{
Returns the p-value of Levene's test of homogeneity
of variances and its practical interpretation for
significance level of 5\%.
}
\description{
\code{levene} Performs the test for homogeneity of variances
of Levene (1960).
}
\examples{
data(ex1)
attach(ex1)
crd(trat, ig, quali = FALSE, hvar = "levene")
}
\references{
LEVENE, H. Robust tests for equality of
variances. In: Olkin, I.; Ghurye, S.G.; Hoeffding, W.;
Madow, W.G.; Mann, H.B. (eds.). \emph{Contribution to
Probability and Statistics. Stanford}, CA: Stanford
University Press, pages 278-292, 1960.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{samiuddin}},
\code{\link{layard}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
