exact.test <-
function(data,alternative="two.sided",npNumbers=100,beta=0.001,interval=FALSE,method="Z-pooled",model="Binomial",cond.row=TRUE,to.plot=TRUE,ref.pvalue=TRUE){

if(dim(data)[1]!=2 | dim(data)[2]!=2){stop("Input 2x2 table")};
if(length(which(data<0))>0){stop("Can't have negative entries")};
if(length(which(data==0))>2){stop("Can't have more than two 0 entries")};
if(beta < 0 | beta > 1){stop("Beta must be between 0 and 1")};
if(npNumbers <1){stop("Total number of nuisance parameters considered must be at least 1")};
if(!(tolower(alternative) %in% c("less","two.sided","greater"))){
stop("Set alternative to 'less', 'two.sided', or 'greater'")}
if(!(tolower(method) %in% c("z-pooled","pooled","score","z-unpooled","unpooled","boschloo","wald",
"santner and snell","santner","snell"))){
stop("Set method to 'Z-pooled', 'Z-unpooled', or 'Boschloo', or 'santner and snell'")}
if(!(tolower(model) %in% c("binomial","multinomial"))){
stop("Set model to 'Binomial' or 'Multinomial'")}

if(tolower(model)=="binomial"){
results<-binomialCode(data,alternative=alternative,interval=interval,beta=beta,npNumbers=npNumbers,method=method,cond.row=cond.row,to.plot=to.plot,ref.pvalue=ref.pvalue)
list<-list(model=model,method=results$method,alternative=alternative,p.value=results$p.value,
     test.statistic=results$test.statistic,np=results$np,np.range=results$np.range)}

if(tolower(model)=="multinomial"){
results<-multinomialCode(data,alternative=alternative,interval=interval,beta=beta,npNumbers=npNumbers,method=method)
list<-list(model=model,method=results$method,alternative=alternative,p.value=results$p.value,
     test.statistic=results$test.statistic,np1=results$np1,np2=results$np2,
     np1.range=results$np1.range,np2.range=results$np2.range)}

return(list)
}
