% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianSynthesis.R
\name{approximateSimplePosterior}
\alias{approximateSimplePosterior}
\title{Approximate simple Bayesian posterior}
\usage{
approximateSimplePosterior(
  likelihoodProfile,
  chainLength = 1100000,
  burnIn = 1e+05,
  subSampleFrequency = 100,
  priorMean = 0,
  priorSd = 0.5,
  startingValue = 0,
  seed = 1
)
}
\arguments{
\item{likelihoodProfile}{Named vector containing grid likelihood data from \code{Cyclops}.}

\item{chainLength}{Number of MCMC iterations.}

\item{burnIn}{Number of MCMC iterations to consider as burn in.}

\item{subSampleFrequency}{Subsample frequency for the MCMC.}

\item{priorMean}{Prior mean for the regression parameter}

\item{priorSd}{Prior standard deviation for the regression parameter}

\item{startingValue}{Initial state for regression parameter}

\item{seed}{Seed for the random number generator.}
}
\value{
A data frame with the point estimates and 95\% credible intervals for the regression parameter.
Attributes of the data frame contain the MCMC trace for diagnostics.
}
\description{
Approximate a Bayesian posterior from a \code{Cyclops} likelihood profile and normal prior
using the Markov chain Monte Carlo engine BEAST.
}
\examples{
# Simulate some data for this example:
population <- simulatePopulations(createSimulationSettings(nSites = 1))[[1]]

# Fit a Cox regression at each data site, and approximate likelihood function:
cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
  data = population,
  modelType = "cox"
)
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
likelihoodProfile <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "grid")

# Run MCMC
mcmcTraces <- approximateSimplePosterior(
  likelihoodProfile = likelihoodProfile,
  priorMean = 0, priorSd = 100
)

# Report posterior expectation
mean(mcmcTraces$theta)

# (Estimates in this example will vary due to the random simulation)

}
