/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.NormalNormalMeanGibbsOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.HalfNormalOnStdDevPrior;
import org.ohdsi.metaAnalysis.ScalePrior;
import org.ohdsi.metaAnalysis.SkewNormalDataModel;

public class MetaAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter theta;
    private final Parameter mu;
    private final Parameter tau;
    private final OperatorSchedule schedule;

    public MetaAnalysis(DataModel dataModel, ScalePrior scalePrior, double muPriorSd) {
        Likelihood dataLikelihood = dataModel.getLikelihood();
        this.theta = dataModel.getCompoundParameter();
        this.mu = new Parameter.Default("mu", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.tau = scalePrior.getParameter();
        boolean isPrecision = scalePrior.isPrecision();
        DistributionLikelihood hierarchicalLikelihood = new DistributionLikelihood(this.getMuDistribution(this.mu, this.tau, isPrecision));
        hierarchicalLikelihood.addData((Attribute)this.theta);
        int defaultThreads = 0;
        this.likelihood = new CompoundLikelihood(defaultThreads, Arrays.asList(dataLikelihood, hierarchicalLikelihood));
        DistributionLikelihood muPrior = new DistributionLikelihood((Distribution)new NormalDistribution(0.0, muPriorSd));
        muPrior.addData((Attribute)this.mu);
        Likelihood tauPrior = scalePrior.getPrior();
        this.prior = new CompoundLikelihood(Arrays.asList(muPrior, tauPrior));
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double defaultWeight = 1.0;
        this.schedule.addOperator(this.getMuOperator(this.mu, hierarchicalLikelihood, muPrior.getDistribution(), defaultWeight));
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        this.schedule.addOperator(scalePrior.getOperator(hierarchicalLikelihood, defaultWeight, mode));
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (Parameter p : dataModel.getIndividualParameters()) {
            this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(p, null, 0.75, condition, defaultWeight, mode));
        }
    }

    protected MCMCOperator getMuOperator(Parameter mu, DistributionLikelihood likelihood, Distribution prior, double weight) {
        return new NormalNormalMeanGibbsOperator(likelihood, prior, weight);
    }

    protected ParametricDistributionModel getMuDistribution(Parameter mu, Parameter tau, boolean isPrecision) {
        return new NormalDistributionModel(mu, tau, isPrecision);
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> columns = new ArrayList<Loggable>();
        columns.add((Loggable)this.likelihood);
        columns.add((Loggable)this.prior);
        columns.add((Loggable)this.mu);
        columns.add((Loggable)this.tau);
        if (this.theta != null) {
            columns.add((Loggable)this.theta);
        }
        return columns;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        MetaAnalysis analysis = new MetaAnalysis(new SkewNormalDataModel("c:/temp/skewnormal_example_3.csv"), new HalfNormalOnStdDevPrior(0.0, 2.0), 1000.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
    }
}

