% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTT_hazard_shape.R
\encoding{UTF-8}
\name{TTT_hazard_shape}
\alias{TTT_hazard_shape}
\title{Hazard Shape estimation from TTT plot}
\usage{
TTT_hazard_shape(
  formula,
  data = NULL,
  local_reg = loess.options(),
  interpolation = interp.options(),
  silent = FALSE,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} with the response on
the left of an operator \code{~}. The right side must be
\code{1}.}

\item{data}{an optional data frame containing the response variables. If
data is not specified, the variables are taken from the
environment from which \code{\link{TTT_hazard_shape}} is called.}

\item{local_reg}{a list of control parameters for LOESS. See
\code{\link{loess.options}}.}

\item{interpolation}{a list of control parameters for interpolation function. See
\code{\link{interp.options}}.}

\item{silent}{logical. If TRUE, warnings of \code{TTT_hazard_shape} are suppressed.}

\item{...}{further arguments passed to
\code{\link{TTTE_Analytical}}.}
}
\description{
This function can be used so as to estimate hazard shape corresponding
to a given data set.
}
\details{
This function performs a non-parametric estimation of the empirical total
time on test (TTT) plot. Then, this estimated curve can be used so as to
get suggestions about initial values and the search region for parameters
based on hazard shape associated to the  shape of empirical TTT plot.

Use \code{\link{Hazard_Shape}} function to get the results for shape estimation.
}
\examples{
#--------------------------------------------------------------------------------
# Example 1: Increasing hazard and its corresponding TTT plot with simulated data
hweibull <- function(x, shape, scale){
  dweibull(x, shape, scale)/pweibull(x, shape, scale, lower.tail = FALSE)
  }
curve(hweibull(x, shape = 2.5, scale = pi), from = 0, to = 42,
               col = "red", ylab = "Hazard function", las = 1, lwd = 2)

y <- rweibull(n = 50, shape = 2.5, scale = pi)
my_initial_guess <- TTT_hazard_shape(formula = y ~ 1)
my_initial_guess$hazard_type


#--------------------------------------------------------------------------------
}
\seealso{
\code{\link{Hazard_Shape}}, \code{\link{plot.HazardShape}}
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
\concept{HazardShape}
