% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiental.R
\name{tdelta}
\alias{tdelta}
\title{Optimum conditions for pesticide application}
\usage{
tdelta(
  LON,
  LAT,
  type = 2,
  days = 7,
  control = NULL,
  details = FALSE,
  verbose = TRUE,
  dates = NULL,
  plot = FALSE
)
}
\arguments{
\item{LON}{Longitude (in decimal)}

\item{LAT}{Latitude (in decimal)}

\item{type}{Type of analysis. Use 1 for forecast and 2 for temporal data.}

\item{days}{Number of days (only use this argument if type=1).}

\item{control}{Type of product to be applied. Use 'fung' for fungicide,
'herb' for herbicide, 'ins' for insecticides, 'bio' for biological products.}

\item{details}{Returns the result in detail if TRUE.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{dates}{Only use this argument if type=2. Start and end date for obtaining
weather data for a crop cycle.}

\item{plot}{Logical argument. Plots a graphic if 'TRUE'.}
}
\value{
Returns the ideal application times, considering each scenario.
Taking as a parameter a TDELTA between 2 and 8, wind speed between 3 and 8,
and no precipitation.
}
\description{
Determining the ideal time for pesticide application using TDELTA
}
\examples{
\donttest{
library(EstimateBreed)

# Forecasting application conditions
forecast <- tdelta(-53.6969,-28.0638,type=1,days=10,verbose=TRUE)

# Retrospective analysis of application conditions
retrosp <- tdelta(-53.6969,-28.0638,type=2,days=10,
                 dates=c("2023-01-01","2023-05-01"),
                 verbose=TRUE)
}
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
