% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SignalData}
\alias{SignalData}
\title{Dataset for Signal Detection Analysis, reported cases, 1999-2018 (ECDC Atlas export)}
\format{A data frame with 80,834 rows and 11 variables:
\describe{
  \item{HealthTopic}{Disease name e.g. Salmonellosis or Measles}
  \item{Population}{Population characteristics e.g. All cases, Confirmed cases, Serotype AGONA,
  Serotype BAREILLY etc.}
  \item{Indicator}{Indicator e.g. Hospitalised cases, Reported cases, Number of deaths, etc.}
  \item{Time}{Time variable including both yearly data from 1999 to 2017, and monthly data from 1999-01 to 2018-02}
  \item{RegionName}{Geographical level including country names e.g. Austria, Belgium, Bulgaria, etc.}
  \item{NumValue}{Number of cases}
  \item{TimeUnit}{Time unit corresponding to the format of the date in the 'Time' variable  e.g. Year or Month}
  \item{TimeYear}{Year of the date available in the 'Time' variable, regardless of the date format
  i.e. 1999 to 2018}
  \item{TimeMonth}{Month of the date available in the 'Time' variable, regardless of the date format i.e. 1 to 12}
  \item{TimeWeek}{Week of the date available in the 'Time' variable, regardless of the date format
  i.e. NA since this dataset does not include any weekly data}
  \item{TimeDate}{Approximated date corresponding to the date available in the 'Time' variable  (daily format)}
}}
\source{
\url{http://atlas.ecdc.europa.eu/public/index.aspx}
}
\usage{
SignalData
}
\description{
A dataset containing an export from the ECDC Atlas for salmonellosis and measles data.
This export is cleaned and ready for Signal Detection Analysis (see. cleanAtlasExport() )
}
\keyword{datasets}
