% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{regional_runtimes}
\alias{regional_runtimes}
\title{Summarise Regional Runtimes}
\usage{
regional_runtimes(
  regional_output = NULL,
  target_folder = NULL,
  target_date = NULL,
  return_output = FALSE
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{regional_epinow} and stored in the
\code{regional} list.}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{A character string giving the target date for which to extract results
(in the format "yyyy-mm-dd"). Defaults to latest available estimates.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}
}
\value{
A data.table of region run times
}
\description{
Summarise Regional Runtimes
}
\examples{
\donttest{
# example delays
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- EpiNow2::bootstrapped_dist_fit(rlnorm(100, log(6), 1), max_value = 30)
                        
# example case vector from EpiSoon
cases <- EpiNow2::example_confirmed[1:30]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
  
# run basic nowcasting pipeline
regional_out <- regional_epinow(reported_cases = cases,
                                generation_time = generation_time,
                                delays = list(incubation_period, reporting_delay),
                                samples = 100, stan_args = list(warmup = 100),
                                output = c("region", "timing"))

regional_runtimes(regional_output = regional_out$regional)
} 
}
