% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkLite.R
\name{networkLite}
\alias{networkLite}
\alias{networkLite.edgelist}
\alias{networkLite.matrix}
\alias{networkLite.numeric}
\alias{networkLite_initialize}
\title{networkLite Constructor Utilities}
\usage{
networkLite(x, ...)

\method{networkLite}{edgelist}(
  x,
  attr = list(vertex.names = seq_len(attributes(x)[["n"]]), na =
    logical(attributes(x)[["n"]])),
  ...
)

\method{networkLite}{matrix}(
  x,
  attr = list(vertex.names = seq_len(attributes(x)[["n"]]), na =
    logical(attributes(x)[["n"]])),
  ...
)

\method{networkLite}{numeric}(x, directed = FALSE, bipartite = FALSE, ...)

networkLite_initialize(x, directed = FALSE, bipartite = FALSE, ...)
}
\arguments{
\item{x}{Either an \code{edgelist} class network representation (including
network attributes in its \code{attributes} list), or a number
specifying the network size.}

\item{...}{Additional arguments used by other methods.}

\item{attr}{A named list of vertex attributes for the network represented by
\code{x}.}

\item{directed, bipartite}{Common network attributes that may be set via
arguments to the \code{networkLite.numeric} method.}
}
\value{
A networkLite object with edge list \code{el}, vertex attributes \code{attr},
and network attributes \code{gal}.
}
\description{
Constructor methods for \code{networkLite} objects.
}
\details{
Currently there are several distinct \code{networkLite} constructor
methods available.

The \code{edgelist} method takes an \code{edgelist} class object \code{x}
with network attributes attached in its \code{attributes} list, and a named
list of vertex attributes \code{attr}, and returns a \code{networkLite}
object, which is a named list with fields \code{el}, \code{attr}, and
\code{gal}; the fields \code{el} and \code{attr} match the arguments \code{x}
and \code{attr} (the latter coerced to \code{tibble}) respectively, and the
field \code{gal} is the list of network attributes (copied from
\code{attributes(x)}). Missing network attributes \code{directed} and
\code{bipartite} are defaulted to \code{FALSE}; the network size attribute
\code{n} must not be missing. Attributes \code{class}, \code{dim},
\code{dimnames}, \code{vnames}, and \code{mnext} (if present) are not copied
from \code{x} to the \code{networkLite}.  (For convenience, a \code{matrix}
method, identical to the \code{edgelist} method, is also defined, to handle
cases where the edgelist is, for whatever reason, not classed as an
\code{edgelist}.)

The \code{numeric} method takes a number \code{x} as well as the network
attributes \code{directed} and \code{bipartite} (defaulting to \code{FALSE}),
and returns an empty \code{networkLite} with these network attributes and
number of nodes \code{x}.

The constructor \code{networkLite_initialize} is also available for creating
an empty \code{networkLite}, and its \code{x} argument should be a number
indicating the size of the \code{networkLite} to create.

Within \code{tergmLite}, the \code{networkLite} data structure is used in the
calls to \code{ergm} and \code{tergm} \code{simulate} functions.
}
\examples{
\dontrun{
library("EpiModel")
nw <- network_initialize(100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5,
                       tergmLite = TRUE)

# networkLite representation after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)

# Conversion to networkLite class format
nwl <- networkLite(dat$el[[1]], dat$attr)
nwl
}

}
