context("ICM extended models")

# SI Models ---------------------------------------------------------------

test_that("SI, 1G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SI", nsteps = 100, nsims = 1, verbose = FALSE,
                         verbose.int = 1)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_true(all(x$epi$num == 501))
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 1G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SI", nsteps = 100, nsims = 2, verbose = FALSE,
                         verbose.int = 5)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_true(all(x$epi$num == 501))
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  plot(x, qnts.smooth = FALSE, sim.lines = TRUE, mean.smooth = FALSE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 1G, CL: inf.prob = 0", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0, act.rate = 0.25)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SI", nsteps = 25, nsims = 10, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_true(all(x$epi$num == 501))
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 13))
  expect_output(summary(x, at = 25), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 25)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 2G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.5, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1")
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SI", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_true(all(x$epi$num == 501))
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  test_icm(x)
})

test_that("SI, 2G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1")
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SI", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_true(all(x$epi$num == 501))
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 50))
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 1G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SI", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 1G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SI", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 50)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 2G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", a.rate = 1 / 100, a.rate.g2 = NA,
                     ds.rate = 1 / 100, ds.rate.g2 = 1 / 100,
                     di.rate = 1 / 90, di.rate.g2 = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SI", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SI, 2G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", a.rate = 1 / 100, a.rate.g2 = NA,
                     ds.rate = 1 / 100, ds.rate.g2 = 1 / 100,
                     di.rate = 1 / 90, di.rate.g2 = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SI", nsteps = 50, nsims = 2, verbose = FALSE,
                         verbose.int = 5)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 50))
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})


# SIR Models --------------------------------------------------------------

test_that("SIR, 1G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, rec.rate = 1 / 50)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
  control <- control.icm(type = "SIR", nsteps = 100, nsims = 1, verbose = FALSE,
                         verbose.int = 1)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "r.num")
  plot(x, y = "ir.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 1G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, rec.rate = 1 / 50)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
  control <- control.icm(type = "SIR", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "r.num")
  plot(x, y = "ir.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 50)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 1G, CL: inf.prob = 0", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0, act.rate = 0.25, rec.rate = 0)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
  control <- control.icm(type = "SIR", nsteps = 10, nsims = 10, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_equal(max(x$epi$i.num), 1)
  expect_equal(min(x$epi$i.num), 1)
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 13))
  expect_output(summary(x, at = 10), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 10)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 2G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", rec.rate = 1 / 100, rec.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0,
                   s.num.g2 = 500, i.num.g2 = 0, r.num.g2 = 0)
  control <- control.icm(type = "SIR", nsims = 1, nsteps = 100, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 2G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", rec.rate = 1 / 100, rec.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0,
                   s.num.g2 = 500, i.num.g2 = 0, r.num.g2 = 0)
  control <- control.icm(type = "SIR", nsims = 2, nsteps = 50, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 50))
  test_icm(x)
})

test_that("SIR, 1G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 3, rec.rate = 1 / 50,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90,
                     dr.rate = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
  control <- control.icm(type = "SIR", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 1G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 3, rec.rate = 1 / 50,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90,
                     dr.rate = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
  control <- control.icm(type = "SIR", nsteps = 50, nsims = 2, verbose = FALSE)

  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 50)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 2G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, inf.prob.g2 = 0.1, act.rate = 3,
                     balance = "g1", rec.rate = 1 / 50, rec.rate.g2 = 1 / 50,
                     a.rate = 1 / 100, a.rate.g2 = NA, ds.rate = 1 / 100,
                     ds.rate.g2 = 1 / 100, di.rate = 1 / 90,
                     di.rate.g2 = 1 / 90, dr.rate = 1 / 100,
                     dr.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0,
                   s.num.g2 = 500, i.num.g2 = 0, r.num.g2 = 0)
  control <- control.icm(type = "SIR", nsteps = 100, nsims = 1, verbose = FALSE,
                         verbose.int = 5)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIR, 2G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, inf.prob.g2 = 0.1, act.rate = 3,
                     balance = "g1", rec.rate = 1 / 50, rec.rate.g2 = 1 / 50,
                     a.rate = 1 / 100, a.rate.g2 = NA, ds.rate = 1 / 100,
                     ds.rate.g2 = 1 / 100, di.rate = 1 / 90,
                     di.rate.g2 = 1 / 90,  dr.rate = 1 / 100,
                     dr.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, r.num = 0,
                   s.num.g2 = 500, i.num.g2 = 0, r.num.g2 = 0)
  control <- control.icm(type = "SIR", nsteps = 50, nsims = 2, verbose = FALSE,
                         verbose.int = 1)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  test_icm(x)
})


# SIS Models --------------------------------------------------------------

test_that("SIS, 1G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, rec.rate = 1 / 50)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SIS", nsteps = 100, nsims = 1, verbose = FALSE,
                         verbose.int = 1)
  x <- icm(param, init, control)
  expect_equal(max(x$epi$s.num + x$epi$i.num), 501)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIS, 1G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, rec.rate = 1 / 50)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SIS", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_equal(max(x$epi$s.num + x$epi$i.num), 501)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 50)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIS, 1G, CL: inf.prob = 0", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0, act.rate = 0.25, rec.rate = 0)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SIS", nsteps = 10, nsims = 10, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 13))
  expect_output(summary(x, at = 10), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 10)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIS, 2G, CL: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", rec.rate = 1 / 100, rec.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SIS", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  test_icm(x)
})

test_that("SIS, 2G, CL: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.25, inf.prob.g2 = 0.1,
                     balance = "g1", rec.rate = 1 / 100, rec.rate.g2 = 1 / 100)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 0)
  control <- control.icm(type = "SIS", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 50))
  test_icm(x)
})

test_that("SIS, 1G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.5, rec.rate = 1 / 50,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SIS", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 100)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIS, 1G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, act.rate = 0.5, rec.rate = 1 / 50,
                     a.rate = 1 / 100, ds.rate = 1 / 100, di.rate = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1)
  control <- control.icm(type = "SIS", nsteps = 50, nsims = 2, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  comp_plot(x, at = 50)
  expect_error(comp_plot(x, at = 200))
  test_icm(x)
})

test_that("SIS, 2G, OP: 1 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, inf.prob.g2 = 0.1, act.rate = 0.5,
                     balance = "g1", rec.rate = 1 / 50, rec.rate.g2 = 1 / 50,
                     a.rate = 1 / 100, a.rate.g2 = NA, ds.rate = 1 / 100,
                     ds.rate.g2 = 1 / 100, di.rate = 1 / 90,
                     di.rate.g2 = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 1)
  control <- control.icm(type = "SIS", nsteps = 100, nsims = 1, verbose = FALSE)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_output(summary(x, at = 100), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 100))
  test_icm(x)
})

test_that("SIS, 2G, OP: 2 sim", {
  skip_on_cran()
  param <- param.icm(inf.prob = 0.2, inf.prob.g2 = 0.1, act.rate = 0.5,
                     balance = "g1", rec.rate = 1 / 50, rec.rate.g2 = 1 / 50,
                     a.rate = 1 / 100, a.rate.g2 = NA, ds.rate = 1 / 100,
                     ds.rate.g2 = 1 / 100, di.rate = 1 / 90,
                     di.rate.g2 = 1 / 90)
  init <- init.icm(s.num = 500, i.num = 1, s.num.g2 = 500, i.num.g2 = 1)
  control <- control.icm(type = "SIS", nsteps = 50, nsims = 2, verbose = FALSE,
                         verbose.int = 5)
  x <- icm(param, init, control)
  expect_is(x, "icm")
  expect_is(as.data.frame(x), "data.frame")
  expect_is(as.data.frame(x, out = "vals"), "data.frame")
  expect_is(as.data.frame(x, out = "mean"), "data.frame")
  expect_is(as.data.frame(x, out = "sd"), "data.frame")
  expect_error(as.data.frame(x, out = "vals", sim = 3))
  expect_output(summary(x, at = 50), "EpiModel Summary")
  expect_error(summary(x, at = 200))
  plot(x)
  plot(x, y = "i.num")
  plot(x, y = "si.flow", mean.smooth = TRUE)
  expect_error(plot(x, y = "sr.flow"))
  expect_error(comp_plot(x, at = 50))
  test_icm(x)
})
