% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_transmat}
\alias{get_transmat}
\title{Extract Transmissions Matrix from Network Epidemic Model}
\usage{
get_transmat(x, sim = 1)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{\link{netsim}}.}

\item{sim}{simulation number of extracted network.}
}
\value{
A data frame with the following collumns
\itemize{
 \item \strong{at:} the time step at which the transmission occurred.
 \item \strong{sus:} the ID number of the susceptible (newly infected) node.
 \item \strong{inf:} the ID number of the infecting node.
 \item \strong{infDur:} the duration of the infecting node's disease at the
       time of the transmission.
 \item \strong{transProb:} the probability of transmission per act.
 \item \strong{actRate:} the rate of acts per unit time.
 \item \strong{finalProb:} the final transmission probability for the
       transmission event.
}
}
\description{
Extracts the matrix of transmission data for each transmission
             event that occured within a network epidemic model.
}
\examples{
\dontrun{
## Simulate SI epidemic on bipartite Bernoulli random graph
nw <- network.initialize(n = 100, bipartite = 50, directed = FALSE)
formation <- ~ edges
target.stats <- 50
dissolution <- ~ offset(edges)
duration <- 20
coef.diss <- dissolution_coefs(dissolution, duration)
est <- netest(nw,
               formation,
               dissolution,
               target.stats,
               coef.diss,
               verbose = FALSE)
param <- param.net(inf.prob = 0.3, inf.prob.m2 = 0.15)
init <- init.net(i.num = 10, i.num.m2 = 10)
control <- control.net(type = "SI", nsteps = 10, nsims = 3,
                       verbose = FALSE)
mod <- netsim(est, param, init, control)

## Extract the transmission matrix from simulation 2
get_transmat(mod, sim = 2)
}
}
\keyword{extract}

