% Generated by roxygen2 (4.0.1): do not edit by hand
\name{as.data.frame.icm}
\alias{as.data.frame.icm}
\alias{as.data.frame.netsim}
\title{Extract Model Data for Stochastic Models}
\usage{
\method{as.data.frame}{icm}(x, row.names = NULL, optional = FALSE, sim,
  out = "mean", ...)

\method{as.data.frame}{netsim}(x, row.names = NULL, optional = FALSE, sim,
  out = "mean", ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{icm} or \code{netsim}.}

\item{sim}{simulation number from model; used only if more than 1 simulation
and \code{out="vals"}.}

\item{out}{data output to data frame: \code{"mean"} for row means across
simulations, \code{"sd"} for row standard deviations across simulations,
and \code{"vals"} for values from one specific simulation (with simulation
number set with \code{sim} argument).}

\item{row.names}{see \code{\link{as.data.frame.default}}.}

\item{optional}{see \code{\link{as.data.frame.default}}.}

\item{...}{see \code{\link{as.data.frame.default}}.}
}
\description{
This function extracts model simulations for objects of classes
             \code{icm} and \code{netsim} into a data frame using
             the generic \code{as.data.frame} function.
}
\details{
These methods work for both \code{icm} and \code{netsim}
class models. The available output includes time-specific means,
standard deviations, and simulation values (compartment and flow sizes from
one simulation) from these stochastic model classes. Means and standard
deviations are calculated by taking the row summary across all simulations
for each time step in the model output.
}
\examples{
## Stochastic ICM SIS model with 5 simulations
param <- param.icm(inf.prob = 0.8, act.rate = 2, rec.rate = 0.1)
init <- init.icm(s.num = 500, i.num = 1)
control <- control.icm(type = "SIS", nsteps = 25,
                       nsims = 5, verbose = FALSE)
mod <- icm(param, init, control)

# Default output is mean across simulations
as.data.frame(mod)

# Standard deviations of simulations
as.data.frame(mod, out = "sd")

# Individual simulation runs, with default sim=1
as.data.frame(mod, out = "vals")
as.data.frame(mod, out = "vals", sim = 2)
}
\keyword{extract}

