% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.R
\name{RandomMap}
\alias{RandomMap}
\title{Create a map by randomly selecting points}
\usage{
RandomMap(data, k, coordsFn)
}
\arguments{
\item{data}{Input data matrix, with individual data points in rows}

\item{k}{How many points to sample}

\item{coordsFn}{a function to generate embedding coordinates (default none)}
}
\value{
map object (without the grid, if \code{coordsFn} was not specified)
}
\description{
Create a map by randomly selecting points
}
\examples{
d <- iris[,1:4]
EmbedSOM::PlotEmbed(
  EmbedSOM::EmbedSOM(
    data = d,
    map = EmbedSOM::RandomMap(d, 30, EmbedSOM::GraphCoords())),
  pch=19, clust=iris[,5]
)
}
