% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelo.R
\name{likelo}
\alias{likelo}
\title{(log) likelihood of Elo-rating model}
\usage{
likelo(eloobject, burnin = 0, ll = TRUE, daterange = NULL)
}
\arguments{
\item{eloobject}{output from \code{\link{elo.seq}} (or from \code{\link{fastelo}})}

\item{burnin}{numeric, the number of interactions to be excluded from the calculation of the (log) likelihood. This parameter is ignored if a date range is supplied. By default \code{burnin = 0}, i.e. all interactions are considered.}

\item{ll}{logical, should the log likelihood be returned rather than the likelihood, by default \code{TRUE}}

\item{daterange}{character or Date of length 2, gives the date range for which likelihood should be calculated. By default, the entire date range of all interactions is considered.}
}
\value{
numeric of length 1, the (log) likelihood
}
\description{
(log) likelihood of Elo-rating model
}
\details{
This function returns the (log) likelihood of a dominance interaction sequence. The likelihood is the product of all winning probabilities (for each interaction).
}
\examples{
data(adv)
res <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date, k = 200)
likelo(res)
res <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date, k = 100)
likelo(res)
ks <- seq(100, 400, by = 20)
liks <- numeric(length(ks))
for(i in 1:length(liks)) {
  liks[i] <- likelo(elo.seq(winner = adv$winner, loser = adv$loser,
                    Date = adv$Date, k = ks[i]))
}
plot(ks, liks, type = "l")

# discard early interactions via 'burnin'
likelo(res)
# the same as above:
likelo(res, burnin = 0)
# discard the first 10 interactions:
likelo(res, burnin = 10)
# discard all but the last interaction:
likelo(res, burnin = 32)
# which is the same as the log of the last winning probability:
log(winprob(res$logtable$Apre[33], res$logtable$Bpre[33]))
}
\references{
\insertRef{franz2015a}{EloRating}

\insertRef{mcmahan1984}{EloRating}
}
