#' NBA games 1995-96
#'
#' Outcome of NBA games during the 1995-1996 regular season, adapted from a dataset 
#'   from fivethirtyeight
#'
#' @format A data frame with 1189 rows and 3 variables:
#' \describe{
#'   \item{Date}{date of game}
#'   \item{Winner}{winning team}
#'   \item{Loser}{losing team}
#' }
#' @source \url{https://github.com/fivethirtyeight/data/blob/master/nba-elo/nbaallelo.csv}
"nba"


#' Anonymized male chimpanzee pant-grunt data from Gombe
#'
#' Data from Gombe National Park, Tanzania from 1978 to 2011.  Data 
#'   are submissive pant-grunt vocalizations.
#'
#' @format A data frame with 2741 rows and 3 variables:
#' \describe{
#'   \item{Date}{date of interaction}
#'   \item{Winner}{winning individual}
#'   \item{Loser}{losing individual}
#' }
#' @source Supplemental data published with Foerster, Franz et al. (2016).
#'   \url{https://datadryad.org/resource/doi:10.5061/dryad.r4g74}
"chimpagg_m"


#' Anonymized male chimpanzee presence data from Gombe
#'
#' Male presence data from Gombe National Park, Tanzania from 1978 to 2011.  
#'   Presence criteria are given in Foerster, Franz et al. (2016)
#'   
#'
#' @format A data frame with 22 rows and 3 variables:
#' \describe{
#'   \item{id}{male code}
#'   \item{start_date}{start date}
#'   \item{end_date}{date of departure}
#' }
#' @source Supplemental data published with Foerster, Franz et al. (2016).
#'   \url{https://datadryad.org/resource/doi:10.5061/dryad.r4g74}
"chimppres_m"



#' Anonymized female chimpanzee pant-grunt data from Gombe
#'
#' Female data from Gombe National Park, Tanzania from 1969 to 2013.  
#'   Data are submissive pant-grunt vocalizations.
#'
#' @format A data frame with 1015 rows and 3 variables:
#' \describe{
#'   \item{Date}{date of interaction}
#'   \item{Winner}{winning individual}
#'   \item{Loser}{losing individual}
#' }
#' @source Supplemental data published with Foerster, Franz et al. (2016).
#'   \url{https://datadryad.org/resource/doi:10.5061/dryad.r4g74}
"chimpagg_f"


#' Anonymized female chimpanzee presence data from Gombe
#'
#' Female presence data from Gombe National Park, Tanzania from 1969 to 2013.  
#'   Presence criteria are given in Foerster, Franz et al. (2016)
#'   
#'
#' @format A data frame with 44 rows and 3 variables:
#' \describe{
#'   \item{id}{female code}
#'   \item{start_date}{start date}
#'   \item{end_date}{date of departure}
#' }
#' @source Supplemental data published with Foerster, Franz et al. (2016).
#'   \url{https://datadryad.org/resource/doi:10.5061/dryad.r4g74}
"chimppres_f"