% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.stars.DIFboost.R
\name{effectstars.DIFboost}
\alias{effectstars.DIFboost}
\title{Plot effect stars for DIFboost objects.}
\usage{
\method{effectstars}{DIFboost}(x, only.DIFitems = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link[DIFboost]{DIFboost}}-object.}

\item{only.DIFitems}{If \code{TRUE}, only the estimates unequal to zero (estimates from the DIF-items)
are visualized with EffectStars.}

\item{...}{further arguments for generic function \code{\link{effectstars}}.}
}
\description{
Plots effect stars for \code{\link[DIFboost]{DIFboost}}-objects. The parameter estimates 
for DIF-items are plotted, grouped by items. \cr

For more details on plotting effect stars see \code{\link{effectstars}}.
}
\examples{
\dontrun{
### example for DIFboost

library(DIFboost)
data(simul.data)

Y <- simul.data[,1:10]
X <- simul.data[,11:13]

m1 <- DIFboost(Y = Y, X = X) 

effectstars(m1)

}
}
\author{
Gunther Schauberger \cr
\email{gunther@stat.uni-muenchen.de} \cr \cr
\url{http://www.statistik.lmu.de/~schauberger/}
}
\references{
Schauberger, G. and Tutz, G. (2016): \emph{Detection of Differential Item Functioning in Rasch Models by Boosting Techniques}, 
British Journal of Mathematical and Statistical Psychology, 69(1), 80 - 103  \cr \cr
Tutz, G. and Schauberger, G. (2013): \emph{Visualization of Categorical Response Models -
from Data Glyphs to Parameter Glyphs}, Journal of Computational and Graphical Statistics 22(1), 156--177.
\cr \cr  Gerhard Tutz (2012): \emph{Regression for Categorical Data}, Cambridge University Press
}
\seealso{
\code{\link{star.ctrl}},  \code{\link{effectstars}}
}

