% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showCutPoints.R
\name{showCutPoints}
\alias{showCutPoints}
\title{Retrieve Achievement Level Cutpoints}
\usage{
showCutPoints(data)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}
}
\value{
If there are achievement levels defined, prints one line per subject scale.
Each line names the subject and then shows the cut point for each achievement level.
}
\description{
Retrieves a summary of the achievement level cutpoints for a
             selected study represented in an
             \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
             or an \code{edsurvey.data.frame.list}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# show the cut points
showCutPoints(data=sdf)
}
}
\author{
Michael Lee and Paul Bailey
}
