% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edsurvey.data.frame.list.R
\name{edsurvey.data.frame.list}
\alias{edsurvey.data.frame.list}
\alias{append.edsurvey.data.frame.list}
\title{EdSurvey Dataset Vectorization}
\usage{
edsurvey.data.frame.list(datalist, cov = NULL, labels = NULL)

append.edsurvey.data.frame.list(sdfA, sdfB, labelsA = NULL, labelsB = NULL)
}
\arguments{
\item{datalist}{a list of \code{edsurvey.data.frame}s to be combined}

\item{cov}{a character vector that indicates what varies across
the \code{edsurvey.data.frame} objects.
Guessed if not supplied. For example,
if several \code{edsurvey.data.frame}s for several
different countries are supplied, then \code{cov} would
be set to the country.}

\item{labels}{a character vector that specifies labels. Must be the
same length
as \code{datalist}. Not needed if \code{cov} exists or can be
guessed. See Examples.}

\item{sdfA}{an \code{edsurvey.data.frame} or an \code{edsurvey.data.frame.list} to be combined}

\item{sdfB}{an \code{edsurvey.data.frame} or an \code{edsurvey.data.frame.list} to be combined}

\item{labelsA}{a character vector that specifies \code{labels} for \code{sdfA} when creating
the new \code{edsurvey.data.frame.list}.}

\item{labelsB}{a character vector that specifies \code{labels} for \code{sdfB} when creating
the new \code{edsurvey.data.frame.list}.}
}
\value{
\code{edsurvey.data.frame.list} returns an \code{edsurvey.data.frame.list} with
elements
\item{datalist}{a list of \code{edsurvey.data.frame} objects}
\item{covs}{a character vector of key variables that vary within
                   the \code{edsurvey.data.frame.list}.
                   When labels are included, they will be included in
                   \code{covs}. In the unusual circumstance that \code{sdfA} or \code{sdfB}
                   is an \code{edsurvey.data.frame.list}
                   has \code{covs}, and labels are not supplied, the \code{covs}
                   are simply pasted together with colons between them.}

\code{append.edsurvey.data.frame.list} returns an \code{edsurvey.data.frame.list} with
elements
\item{datalist}{a list of \code{edsurvey.data.frame} objects}
\item{covs}{a character vector of key variables that vary within
                   the \code{edsurvey.data.frame.list}.
                   When labels are included, they will be included in
                   \code{covs}.}
}
\description{
The \code{edsurvey.data.frame.list} function creates an
             \code{edsurvey.data.frame.list} object from a series of
             \code{edsurvey.data.frame} objects.
             \code{append.edsurvey.data.frame.list} creates an
             \code{edsurvey.data.frame.list} from two
             \code{edsurvey.data.frame} or \code{edsurvey.data.frame.list} objects.

             An \code{edsurvey.data.frame.list} is useful for looking at
             data, for example, across time or graphically, and reduces
             repetition in function calls.
             The user may specify a variable that varies across the
             \code{edsurvey.data.frame} objects that is
             then included in further output.
}
\details{
The \code{edsurvey.data.frame.list} can be used in place of an
\code{edsurvey.data.frame} in function calls, and results are returned
for each of the component \code{edsurvey.data.frame}s, with the
organization of the results varying by the particular method.

An \code{edsurvey.data.frame.list} can be created from several
\code{edsurvey.data.frame} objects that are related;
for example, all are NAEP mathematics assessments but have one or more
differences (e.g.,  they are all from different years).
Another example could be data from multiple countries for an
international assessment.

When \code{cov} and \code{labels} are both missing, \code{edsurvey.data.frame.list}
attempts to guess what variables may be varying and uses those. When there are no
varying covariates, generic labels are automatically generated.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# NOTE: the following code would not normally have to be run but is used here
# to generate demo data.
# Specifically, make subsets of sdf by the scrpsu variable,
# "Scrambled PSU and school code"
sdfA <- subset(sdf, scrpsu \%in\% c(5,45,56))
sdfB <- subset(sdf, scrpsu \%in\% c(75,76,78))
sdfC <- subset(sdf, scrpsu \%in\% 100:200)
sdfD <- subset(sdf, scrpsu \%in\% 201:300)

# construct an edsurvey.data.frame.list from these four data sets
sdfl <- edsurvey.data.frame.list(list(sdfA, sdfB, sdfC, sdfD),
                                 labels=c("A locations",
                                          "B locations",
                                          "C locations",
                                          "D locations"))

# alternative method of building
sdfl2 <- sdfA + sdfB + sdfC

# check contents
sdfA \%in\% sdfl
# note \%in\% checks by survey (NAEP 2005 Math for sdf,
# sdfA, sdfB, sdfC, and sdfD) not by subset, so this also return TRUE
sdfD \%in\% sdfl2

# this shows how these datasets will be described
sdfl$covs 
# get the gaps between Male and Female for each data set
gap1 <- gap("composite", sdfl, dsex=="Male", dsex=="Female")
gap1

# make combine sdfA and sdfB
sdfl1a <- edsurvey.data.frame.list(list(sdfA, sdfB),
                                   labels=c("A locations",
                                            "B locations"))

# combine sdfC and sdfD
sdfl1b <- edsurvey.data.frame.list(list(sdfC, sdfD),
                                   labels=c("C locations",
                                            "D locations"))

# append to make sdf3 the same as sdfl
sdfl3 <- append.edsurvey.data.frame.list(sdfl1a, sdfl1b)
identical(sdfl, sdfl3) #TRUE

# append to make sdf4 the same as sdfl
sdfl4 <- append.edsurvey.data.frame.list(
  append.edsurvey.data.frame.list(sdfl1a, sdfC, labelsB = "C locations"),
  sdfD,
  labelsB = "D locations")
identical(sdfl, sdfl4) #TRUE

# show label deconflicting
downloadTIMSS(root="~/", years=c(2011, 2015))
t11 <- readTIMSS("~/TIMSS/2011", countries = c("fin", "usa"), gradeLvl = 4)
t15 <- readTIMSS("~/TIMSS/2015", countries = c("fin", "usa"), gradeLvl = 4)
# these would not be unique
t11$covs
t15$covs
# resulting values includes year now
t11_15 <- append.edsurvey.data.frame.list(t11, t15)
t11_15$covs

}
}
\author{
Paul Bailey, Huade Huo
}
