% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim3}
\alias{sim3}
\title{Sim3 Co-occurrence Randomization Algorithm}
\usage{
sim3(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and colsums as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling elements
within each column equiprobably.
}
\details{
This algorithm assumes species are equiprobable, but preserves
differences among sites (= column sums).
}
\note{
This algorithm preserves differences in species richness among sites
(= colsums), but assumes that all species are equiprobable. This assumption
is usually unrealistic, and sim3 has a high frequency of Type I errors with
random matrices, so it is not recommended for co-occurrence analysis.
}
\examples{
randomMatrix <- sim3(speciesData=matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.
}

