% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{ecogen2spagedi}
\alias{ecogen2spagedi}
\title{Exporting an ecogen genetic data frame into SPAGeDi format}
\usage{
ecogen2spagedi(
  eco,
  pop = NULL,
  ndig = NULL,
  dir = "",
  outName = "infile.spagedi.txt",
  smin = 0,
  smax = NULL,
  int = NULL,
  nclass = NULL,
  seqvec = NULL,
  size = NULL,
  bin = c("sturges", "FD"),
  distmat = NULL,
  latlon = FALSE,
  to_numeric = FALSE,
  nout = 3,
  recode = c("all", "column", "paired"),
  replace_in = NULL,
  replace_out = NULL,
  ...
)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{pop}{The name of the S slot column with the groups 
for the output data. The default option includes all the individuals into 
a single group.}

\item{ndig}{Number of digits coding each allele in the output file
(e.g., 1: x, 2: xx, or 3: xxx). If NULL, the vale will be deduced from
the number of digits used for coding alleles in the ecogen object.}

\item{dir}{output path. Default = "" (current directory).}

\item{outName}{The name of the output file.}

\item{smin}{Minimum class distance in the units of the XY slot data.}

\item{smax}{Maximum class distance in the units of the XY slot data.}

\item{int}{Distance interval in the units of the XY slot data.}

\item{nclass}{Number of classes.}

\item{seqvec}{Vector with breaks in the units of the XY slot data.}

\item{size}{Number of individuals per class.}

\item{bin}{Rule for constructing intervals when a partition parameter (int, 
nclass or size) is not given. Default is Sturge's rule (Sturges, 1926). Other
option is Freedman-Diaconis method (Freedman and Diaconis, 1981).}

\item{distmat}{Distance matrix to include (optional).}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}

\item{to_numeric}{Recode the genetic data into numeric format? If TRUE, 
the functions performs the correction via \code{\link{eco.format}}.
Additional formatting parameters can be passed to this function.}

\item{nout}{Number of digits in the output when to_numeric = TRUE.}

\item{recode}{Recode mode when to_numeric = TRUE: "all" for recoding
the data considering all the individuals values at once (e.g., protein data), 
"column" for recoding the values by column (e.g., microsatellite data), "paired" 
for passing the values of allelic states and corresponding replacement values, using 
the replace_in and replace_out arguments (e.g. replace_in = c("A", "T", "C", "G"),
replace_out = c(1,2,3,4)).}

\item{replace_in}{vector with states of the data matrix to be replaced, when recode = "paired".
This argument must be used in conjunction with the argument "replace_out".}

\item{replace_out}{vector with states of the data matrix used for replacement, when recode = "paired".
This argument must be used in conjunction with the argument "replace_in".}

\item{...}{Additional parameters passed to \code{\link{eco.format} when to_numeric = TRUE}}
}
\description{
This function converts the genetic data of an ecogen object 
in a SPAGeDi input file.  
When distance classes are required, they can be constructed by combining 
the parameters "int", "smin", "smax", "nclass", "seqvec" and "size", as
described in the function \code{\link{eco.lagweight}}.
A distance matrix can also be included using the "distmat" parameter.
Missing data must be coded as a single "NA" in the G data frame.
}
\examples{

\dontrun{

data(eco.test)
ecogen2spagedi(eco, dir = "", pop = "pop", ndig = 1,int=2, smax=6, outName="infile.spagedi.txt")

}

}
\references{
Freedman D., and P. Diaconis. 1981. On the histogram as a density estimator: 
L 2 theory. Probability theory and related fields, 57: 453-476.

Hardy O. and X Vekemans. 2002. SPAGeDi: a versatile computer program 
to analyse spatial genetic structure at the individual or population levels. 
Molecular ecology notes, 2: 18-620.

Sturges  H. 1926. The choice of a class interval. Journal of the American 
Statistical Association, 21: 65-66.
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
