% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.rbind.R
\name{eco.rbind}
\alias{eco.rbind}
\title{Combining ecogen objects by row}
\usage{
eco.rbind(..., check_colnames = TRUE, check_rownames = TRUE)
}
\arguments{
\item{...}{"ecogen" objects to combine.}

\item{check_colnames}{Check for duplicated column names? Default TRUE.}

\item{check_rownames}{Check for duplicated row names? Default TRUE.}
}
\description{
Combining ecogen objects by row
}
\examples{

\dontrun{

data(eco.test)

# split the object "eco" into a list of ecogen objects by population
x <- eco.split(eco, "pop", asList = TRUE)

# re-bind the objects
eco.r <- eco.rbind(eco)

# create a new objects with the first and second population
eco.r <- eco.rbind(x[[1]], x[[3]])

# duplicated row names are not allowed by eco.rbind with default options
eco2 <- eco
eco.rbind(eco, eco2)

eco.rbind(eco, eco2,check_rownames = FALSE)
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
