% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/ecogen.5OF6.get&set.R,
%   R/ecopop.5OF6.get&set.R, R/accessors.R
\docType{methods}
\name{EcoGenetics accessors}
\alias{EcoGenetics accessors}
\alias{ecoslot.XY}
\alias{ecoslot.XY<-}
\alias{ecoslot.P}
\alias{ecoslot.P<-}
\alias{ecoslot.G}
\alias{ecoslot.G<-}
\alias{ecoslot.A}
\alias{ecoslot.A<-}
\alias{ecoslot.AF}
\alias{ecoslot.AF<-}
\alias{ecoslot.E}
\alias{ecoslot.E<-}
\alias{ecoslot.S}
\alias{ecoslot.S<-}
\alias{ecoslot.C}
\alias{ecoslot.C<-}
\alias{ecoslot.OUT}
\alias{ecoslot.OUT<-}
\alias{int.ecoslot.INT}
\alias{ecoslot.XY,ecogen-method}
\alias{ecoslot.XY<-,ecogen-method}
\alias{ecoslot.P,ecogen-method}
\alias{ecoslot.P<-,ecogen-method}
\alias{ecoslot.G,ecogen-method}
\alias{ecoslot.G<-,ecogen-method}
\alias{ecoslot.A,ecogen-method}
\alias{ecoslot.A<-,ecogen-method}
\alias{ecoslot.E,ecogen-method}
\alias{ecoslot.E<-,ecogen-method}
\alias{ecoslot.S,ecogen-method}
\alias{ecoslot.S<-,ecogen-method}
\alias{ecoslot.C,ecogen-method}
\alias{ecoslot.C<-,ecogen-method}
\alias{ecoslot.OUT,ecogen-method}
\alias{ecoslot.OUT<-,ecogen-method}
\alias{int.ecoslot.INT<-}
\alias{ecoslot.XY,ecopop-method}
\alias{ecoslot.XY<-,ecopop-method}
\alias{ecoslot.P,ecopop-method}
\alias{ecoslot.P<-,ecopop-method}
\alias{ecoslot.AF,ecopop-method}
\alias{ecoslot.AF<-,ecopop-method}
\alias{ecoslot.E,ecopop-method}
\alias{ecoslot.E<-,ecopop-method}
\alias{ecoslot.S,ecopop-method}
\alias{ecoslot.S<-,ecopop-method}
\alias{ecoslot.C,ecopop-method}
\alias{ecoslot.C<-,ecopop-method}
\alias{EcoGenetics accessors}
\alias{ecoslot.ALTER}
\alias{ecoslot.ANALYSIS}
\alias{ecoslot.ANOVA.MLM}
\alias{ecoslot.AVERAGE}
\alias{ecoslot.BREAKS}
\alias{ecoslot.CARDINAL}
\alias{ecoslot.COND}
\alias{ecoslot.CONNECTED}
\alias{ecoslot.DF1}
\alias{ecoslot.DF2}
\alias{ecoslot.DISTMETHOD}
\alias{ecoslot.EXP}
\alias{ecoslot.FREQUENCIES}
\alias{ecoslot.GF}
\alias{ecoslot.IN}
\alias{ecoslot.LOGMEAN}
\alias{ecoslot.LWR}
\alias{ecoslot.MEAN}
\alias{ecoslot.METHOD}
\alias{ecoslot.MLM}
\alias{ecoslot.MODEL}
\alias{ecoslot.MULTI}
\alias{ecoslot.NAMES}
\alias{ecoslot.NONZERO}
\alias{ecoslot.NONZEROIND}
\alias{ecoslot.NSIM}
\alias{ecoslot.OBS}
\alias{ecoslot.OBS.RES}
\alias{ecoslot.PADJUST}
\alias{ecoslot.PAR}
\alias{ecoslot.PAR.VAL}
\alias{ecoslot.POLY.DEG}
\alias{ecoslot.POP}
\alias{ecoslot.PREDICTIONS}
\alias{ecoslot.PVAL}
\alias{ecoslot.RES}
\alias{ecoslot.ROW.SD}
\alias{ecoslot.SELF}
\alias{ecoslot.SP}
\alias{ecoslot.SUMMARY.MLM}
\alias{ecoslot.TEST}
\alias{ecoslot.TREES}
\alias{ecoslot.UPPR}
\alias{ecoslot.W}
\title{Generic accessors for EcoGenetics objects}
\format{<\strong{ecoslot.}> + <\strong{name of the slot}> + <\strong{(name of the object)}>}
\usage{
ecoslot.XY(X)

ecoslot.XY(object, ...) <- value

ecoslot.P(X)

ecoslot.P(object, ...) <- value

ecoslot.G(X)

ecoslot.G(object, ...) <- value

ecoslot.A(X)

ecoslot.A(object) <- value

ecoslot.AF(X)

ecoslot.AF(object, ...) <- value

ecoslot.E(X)

ecoslot.E(object, ...) <- value

ecoslot.S(X)

ecoslot.S(object, ...) <- value

ecoslot.C(X)

ecoslot.C(object, ...) <- value

ecoslot.OUT(X, ...)

ecoslot.OUT(object) <- value

int.ecoslot.INT(X)

\S4method{ecoslot.XY}{ecogen}(X)

\S4method{ecoslot.XY}{ecogen}(object, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.P}{ecogen}(X)

\S4method{ecoslot.P}{ecogen}(object, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.G}{ecogen}(X)

\S4method{ecoslot.G}{ecogen}(object, G.processed = TRUE, order.G = FALSE,
  type = c("codominant", "dominant"), ploidy = 2, sep, ncod = NULL,
  missing = c("0", "NA", "MEAN"), NA.char = "NA", poly.level = 5,
  rm.empty.ind = FALSE, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.A}{ecogen}(X)

\S4method{ecoslot.A}{ecogen}(object) <- value

\S4method{ecoslot.E}{ecogen}(X)

\S4method{ecoslot.E}{ecogen}(object, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.S}{ecogen}(X)

\S4method{ecoslot.S}{ecogen}(object, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.C}{ecogen}(X)

\S4method{ecoslot.C}{ecogen}(object, use.object.names = FALSE,
  order.rows = FALSE) <- value

\S4method{ecoslot.OUT}{ecogen}(X, ...)

\S4method{ecoslot.OUT}{ecogen}(object) <- value

int.ecoslot.INT(object) <- value

\S4method{ecoslot.XY}{ecopop}(X)

\S4method{ecoslot.XY}{ecopop}(object, order.rows = FALSE) <- value

\S4method{ecoslot.P}{ecopop}(X)

\S4method{ecoslot.P}{ecopop}(object, order.rows = FALSE) <- value

\S4method{ecoslot.AF}{ecopop}(X)

\S4method{ecoslot.AF}{ecopop}(object, order.rows = FALSE) <- value

\S4method{ecoslot.E}{ecopop}(X)

\S4method{ecoslot.E}{ecopop}(object, order.rows = FALSE) <- value

\S4method{ecoslot.S}{ecopop}(X)

\S4method{ecoslot.S}{ecopop}(object, order.rows = FALSE) <- value

\S4method{ecoslot.C}{ecopop}(X)

\S4method{ecoslot.C}{ecopop}(object, order.rows = FALSE) <- value

ecoslot.ALTER(X)

ecoslot.ANALYSIS(X)

ecoslot.ANOVA.MLM(X)

ecoslot.AVERAGE(X)

ecoslot.BREAKS(X)

ecoslot.CARDINAL(X)

ecoslot.COND(X)

ecoslot.CONNECTED(X)

ecoslot.DF1(X)

ecoslot.DF2(X)

ecoslot.DISTMETHOD(X)

ecoslot.EXP(X)

ecoslot.FREQUENCIES(X)

ecoslot.GF(X)

ecoslot.IN(X)

ecoslot.LOGMEAN(X)

ecoslot.LWR(X)

ecoslot.MEAN(X)

ecoslot.METHOD(X)

ecoslot.MLM(X)

ecoslot.MODEL(X)

ecoslot.MULTI(X)

ecoslot.NAMES(X)

ecoslot.NONZERO(X)

ecoslot.NONZEROIND(X)

ecoslot.NSIM(X)

ecoslot.OBS(X)

ecoslot.OBS.RES(X)

ecoslot.PADJUST(X)

ecoslot.PAR(X)

ecoslot.PAR.VAL(X)

ecoslot.POLY.DEG(X)

ecoslot.POP(X)

ecoslot.PREDICTIONS(X)

ecoslot.PVAL(X)

ecoslot.RES(X)

ecoslot.ROW.SD(X)

ecoslot.SELF(X)

ecoslot.SP(X)

ecoslot.SUMMARY.MLM(X)

ecoslot.TEST(X)

ecoslot.TREES(X)

ecoslot.UPPR(X)

ecoslot.W(X)
}
\arguments{
\item{X}{Any S4 object of the formal classes defined in EcoGenetics.}

\item{object}{Object of class ecogen.}

\item{...}{Arguments for G or OUT slots of ecogen objects (see Details).}

\item{value}{Single object or a list of objects to assign. Multiple 
objects v1, v2, ...vn must be passed as a list : list(v1, v2, ...vn).}

\item{use.object.names}{Logical. Use the names stored in the object 
for the assigned data frame? This argument can be combined with order.rows 
if the order of the individuals do not match to the order of the 
other elements in the object. If the names stored in the object are empty, 
in all the cases they will be set to the names of the assigned data frame.}

\item{order.rows}{Order rows of the object after assignnment to align individuals?
This argument can be used when use.object.names is TRUE. Otherwise, it will not have
effect in the function.}

\item{G.processed}{If TRUE, the slot G will include a processed data frame (
removed non informative loci (the data non available for all the individuals),
removed non polymorphic loci (for dominant data) and ordered alleles in ascending
order.}

\item{order.G}{Genotypes must be ordered in G slot? Default FALSE.}

\item{type}{Marker type: "codominant" or "dominant".}

\item{ploidy}{Ploidy of the G data frame. Default ploidy = 2.}

\item{sep}{Character separating alleles. Default option is no
character separating alleles.}

\item{ncod}{Number of characters coding each allele.}

\item{missing}{Missing data treatment ("0", "NA", or "MEAN") for the A
slot. Missing elements are set to 0 in the default option. missing elements
are recoded as "NA" or the mean allelic frequency across individuals in "NA" 
and "MEAN" options, respectively.}

\item{NA.char}{Character simbolizing missing data in the input. Default is "NA".}

\item{poly.level}{Polymorphism threshold in percentage (0 - 100), 
for remotion of non polymorphic loci (for dominant data). Default is 5 (5\%).}

\item{rm.empty.ind}{Remotion of noninformative individuals (rows of "NAs").
Default if FALSE.}
}
\description{
Generic accessors for EcoGenetics objects

These functions provide basic access to the slots of any object
of the formal classes defined in EcoGenetics. In addition, 
for ecogen objects a replace method is defined for the accessor, which enables
basic processing of individual slots.
}
\details{
The accessor notation in EcoGenetics consists of the prefix 
"ecoslot." followed by the name of the slot of interest. E.g., 
to access the slot "IN" of the object "X", type ecoslot.IN(X).

For example, the class eco.correlog of the function \code{\link{eco.correlog}}
has the slots OUT, IN, BREAKS CARDINAL, etc. 
An object X of class eco.correlog, generated with this function, 
has access to these slots using:
ecoslot.OUT(X), ecoslot.IN(X), ecoslot.BREAKS(X) and ecoslot.CARDINAL(X), 
respectively. 


   -----------------------------------------------------------------------

\strong{FOR ECOGEN CLASS ONLY}:

- The accessors in objects of class \code{\link{ecogen}} 
have a double usage. First, the extraction of data included in a slot (\strong{get mode}).  
Second, the assignment of data (\strong{set mode}). The data assigned 
to ecogen objects using this method is properly pre-processed. 

- The get mode is defined for ecoslot.XY, ecoslot.P, ecoslot.G, 
ecoslot.A, ecoslot.E, ecoslot.S and ecoslot.OUT. For any ecogen object X, 
type ecoslot.SLOT(X), where SLOT is the slot of interest: ecoslot.XY(X), 
ecoslot.P(X), ecoslot.G(X), ecoslot.A(X), ecoslot.E(X), ecoslot.S(X) 
and ecoslot.OUT(X, ...). In the latter, the three dots (...) are
objects in the slot OUT. 

- The set mode is a replacement method, i.e.,  
the assignation ecoslot.SLOT(X) <- VALUE is defined for the ecogen class. 

For a generic ecogen object "eco", the defined replacement methods are:

1. ecoslot.P(eco) <- P data frame

2. ecoslot.G(eco, ...) <- G data frame

#' In this case the three dots (...) consist of the following 
variables that can be passed to the function:

- G.processed

- order.G

- type

- ploidy

- sep

- ncod

- missing

- NA.char

- poly.level

- rm.empty.ind

See the arguments of \code{\link{ecogen}} for details about these values, and the
Examples section for details about usage.


\strong{IMPORTANT}: The assignation of data in the slot G, creates automatically the slot A.
An accessor is defined for the slot A only in get mode (to get the data frame in this slot, 
but not for replacement purposes). The slot A cannot be replaced with accessors 
and is generated when a genetic data frame is assigned to the slot G. 

3. ecoslot.E(eco) <- E data frame

4. ecoslot.S(eco) <- S data frame

5. ecoslot.C(eco) <- C data frame

6. ecoslot.OUT(eco, value) <- results to store in the slot OUT.
Here, value means any object(s). 
Several objects can be passed as a list. 
See the section Examples.
}
\examples{

\dontrun{

#--------------
# GENERAL USE
#--------------

# Example 1

data(eco.test)

## Test with phenotypic traits (example of ?eco.correlog)
moran <- eco.correlog(Z=eco[["P"]][,1], XY = eco[["XY"]], method = "I", smax=10, size=1000)
# the slots are accesed with the generic format:
# ecoslot. + name of the slot + (name of the object)

ecoslot.OUT(moran)      # slot OUT
ecoslot.BREAKS(moran)   # slot BREAKS


#----------------------------------------------
# SPECIFIC USE OF ACCESSORS WITH ECOGEN OBJECTS
#----------------------------------------------

#1) GET MODE

# Example 2

# Example with G data of class "data.frame", corresponding to
# microsatellites of a diploid organism.

eco <- ecogen(XY = coordinates, P = phenotype, G = genotype,
              E = environment, S = structure, order.G = TRUE)
eco              


# Access to the slots   

ecoslot.XY(eco) 
ecoslot.P(eco)
ecoslot.G(eco)
ecoslot.A(eco)
ecoslot.E(eco)
ecoslot.S(eco)
ecoslot.C(eco)
ecoslot.OUT(eco)         

# For ecogen objects, the double square brackets ("[[")
# are symbolic abbreviations of the accessors:

ecoslot.XY(eco) 
# is identical to:
eco[["XY"]]

#2) SET MODE (REPLACEMENT OF SLOTS)

# Example 3

eco <- ecogen(XY = coordinates, P = phenotype)
eco

ecoslot.G(eco, order.G = TRUE) <- genotype

# this is identical to
eco[["G", order.G=TRUE]] <- genotype

ecoslot.E(eco) <- environment
ecoslot.S(eco) <- structure

# Storing the data of Example 1 in the slot OUT

ecoslot.OUT(eco) <- moran
 
# Storing several data
singers <- c("carlos_gardel", "billie_holiday")
golden.number <- (sqrt(5) + 1) / 2
ecoslot.OUT(eco) <- list(singers, golden.number)    # several objects must be passed as a list

# In get mode, ecoslot.OUT has a double behavior:
# when only the name of the ecogen object is passed to
# the accessor, it has an overview method, 
# returning a data frame with the objects
# stored and their classes

ecoslot.OUT(eco)

# ecoslot.OUT in get mode, has two arguments:
# ecoslot.OUT(object, ...)
# here, the three dots (...) means any object(s) stored in the slot OUT.

ecoslot.OUT(eco, "moran", "singers")

# In double square brackets notation, this is equivalent to
eco[["OUT"]][c("moran", "singers")]
# This is, it works as a list and have no overview method
eco[["OUT"]]
eco[["OUT"]]["moran"]

# ecoslot.OUT in set mode, has two arguments:
# ecoslot.OUT(object, value)
# here value means object(s) to store in the slot OUT. Several objects
# must be passed as a list.
# The names of the input data is recoded in case of
# duplicates

ecoslot.OUT(eco) <- singers
ecoslot.OUT(eco)
ecoslot.OUT(eco) <- list(singers, singers, singers)
ecoslot.OUT(eco)

# The set operation is equivalent with double square brackets
eco[["OUT"]] <- list(singers, c(1,2,3))
ecoslot.OUT(eco)

}


}
\author{
Leandro Roser \email{learoser@gmail.com}

Leandro Roser \email{learoser@gmail.com}
}
\keyword{internal}
