% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/auxiliar.R
\name{aue.char2num}
\alias{aue.char2num}
\title{Converting data coded with characters into data coded by numbers}
\usage{
aue.char2num(data, ndig = 0)
}
\arguments{
\item{data}{Data frame or matrix for the conversion.}

\item{ndig}{Number of digits coding each allele when the matrix has two
alleles per cell (diploid data). The default option takes each cell
as having a character or string indicating a single information (see examples).}
}
\description{
Converting data coded with characters into data coded by numbers
}
\details{
This function creates a data frame with data recoded in numeric
format.
The output possess a character formatting, for maintaining an uniform
number of digits (for example, data with the code "01" in a
numeric format will be coded as "1", but as many programs require inputs
with uniform number of digits, the program maintains a character format).
The program also creates a data frame with the information
of the numeric code that corresponds to each character/string.
The program expects missing data coded as NA.
}
\examples{
\dontrun{

# Example with a single character:
ex <- c("A","T","G","C")
ex <- sample(ex, 100, rep= T)
ex <- matrix(ex, 10, 10)
colnames(ex) <- letters[1:10]
rownames(ex) <- LETTERS[1:10]
recoded <- aue.char2num(ex)
tab <- recoded$recoded_data
write.table(tab, "recoded.data.txt")

# Example with two strings per cell and missing values:
ex <- c("Ala", "Asx", "Cys", "Asp", "Glu", "Phe", "Gly", "His", "Ile",
"Lys", "Leu", "Met", "Asn", "Pro", "Gln", "Arg", "Ser", "Thr",
"Val", "Trp")
ex1 <- sample(ex, 100, rep= T)
ex2 <- sample(ex, 100, rep= T)
ex3 <- paste(ex1, ex2, sep="")
missing.ex3 <- sample(1:100, 20)
ex3[missing.ex3] <-NA
ex4 <- matrix(ex3, 10, 10)
colnames(ex4) <- letters[1:10]
rownames(ex4) <- LETTERS[1:10]
ex4
recoded <- aue.char2num(ex4, ndig = 3)

# Example with a vector, following the latter example:
ex1 <- as.data.frame(ex1)
ex1
aue.char2num(ex1)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

