% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/other.classes.R
\docType{methods}
\name{plot,eco.boot,ANY-method}
\alias{plot,eco.boot,ANY-method}
\alias{plot,eco.boot-method}
\alias{plot,eco.multiboot,ANY-method}
\alias{plot,eco.multiboot-method}
\alias{plot,eco.permut,ANY-method}
\alias{plot,eco.permut-method}
\alias{plot,eco.variog,ANY-method}
\alias{plot,eco.variog-method}
\title{Plot for lag objects}
\usage{
\S4method{plot}{eco.boot,ANY}(x, var = NULL)

\S4method{plot}{eco.multiboot,ANY}(x, var = NULL)

\S4method{plot}{eco.permut,ANY}(x, var = NULL)

\S4method{plot}{eco.variog,ANY}(x)
}
\arguments{
\item{x}{result of correlogram or variogram analysis.}

\item{var}{Variable to plot (numeric, see examples).}
}
\description{
Plot for lag objects
}
\examples{
\dontrun{

eco.ac <- eco.autocor(eco, int = 50, smax = 1000,
df = "P", select = "moran", nsim = 10)
plot(eco.ac, var = "P2")

#' eco.ac <- eco.autocor(eco, int = 50, smax = 1000,
df = "P", select = "geary", nsim = 10)
plot(eco.ac, var = "P2")

eco.ac <- eco.autocor(eco, int = 50, smax = 1000,
df = "GENIND", select = "joincount", nsim = 10,
indvar="L1.1")
plot(eco.ac)

eco.ac <- eco.autocor(eco, int = 25000, smax = 50000,
df = "P", select = "getisord", nsim = 10)
plot(eco.ac, var = "P2")

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "localmoran", nsim = 10)
plot(eco.ac, var = "P2")

variog <- eco.variogram(eco$P[, 2], eco$XY, int=100,
smax=1000, nsim = 99)
plot(variog)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link{eco.autocor}}
}

