% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.boothet.R
\name{eco.boothet}
\alias{eco.boothet}
\title{Heterozygosity estimates with bootstrap confidence intervals over
individuals and loci, and jackkninfe estimates over populations.}
\usage{
eco.boothet(eco, grp, nrep = 99, boot.indiv = TRUE, boot.loci = TRUE,
  jack.pop = TRUE, pres = FALSE)
}
\arguments{
\item{eco}{ecogen object.}

\item{grp}{Column of the slot S with the populations data.}

\item{nrep}{Number of repetitions for bootstrap resampling.}

\item{boot.indiv}{Logical. Should be performed bootstrap over individuals?
Default TRUE.}

\item{boot.loci}{Logical. Should be performed bootstrap over loci?
Default TRUE.}

\item{jack.pop}{Logical. Should be performed jackknife over populations?
Default TRUE.}

\item{pres}{Logical. Should the output be in presentation mode?
(see details).
Default FALSE.}
}
\description{
Heterozygosity estimates with bootstrap confidence intervals over
individuals and loci, and jackkninfe estimates over populations.
}
\details{
This program estimates  bootstrap confidence intervals for the
observed and expected heterozygosity. The intervals could be computed for
 individual loci (bootstrap over individuals),
for mean values over loci (bootstrap over loci),
and for mean values across populations (by jackknife).
The program also could provide tables with the results formatted
in a presentation style.
}
\examples{
\dontrun{

data(eco.test)
eco.boothet(eco,"structure",nrep = 20)
eco.boothet(eco,"structure",nrep = 20, pres = T)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

