% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{pls}
\alias{pls}
\alias{pls.ER}
\title{Partial Least Squares modelling of ER objects.}
\usage{
pls(er, ...)

\method{pls}{ER}(
  er,
  effect,
  ncomp,
  newdata = NULL,
  er2,
  validation,
  jackknife = NULL,
  shave = NULL,
  df.used = NULL,
  ...
)
}
\arguments{
\item{er}{Object of class \code{ER}.}

\item{...}{Additional arguments for \code{plsr}.}

\item{effect}{The effect to be used as response.}

\item{ncomp}{Number of PLS components.}

\item{newdata}{Optional new data matrix for prediction.}

\item{er2}{Second object of class \code{ER} for comparison.}

\item{validation}{Optional validation parameters for \code{plsr}.}

\item{jackknife}{Optional argument specifying if jackknifing should be applied.}

\item{shave}{Optional argument indicating if variable shaving should be used. \code{shave} should be a list with two elements: the PLS filter method and the proportion to remove. \code{shave = TRUE} uses defaults: \code{list("sMC", 0.2)}.}

\item{df.used}{Optional argument indicating how many degrees of freedom have been consumed during deflation. Default value from input object.}
}
\description{
Partial Least Squares modelling of ER objects.
}
