% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.limits.R
\name{get.limits}
\alias{get.limits}
\title{Infer lower and upper mode position limits to define robust end-members.}
\usage{
get.limits(loadings, classunits, bw, threshold = 0.7)
}
\arguments{
\item{loadings}{\code{R} object, output of function \code{model.EM}.}

\item{classunits}{\code{Numeric} vector, optional class units 
(e.g. micrometers or phi-units) of the same length as columns of \code{X}.}

\item{bw}{\code{Numeric} scalar, bandwidth of the kernel, moved over the 
data set. If omitted, the default value of 1 % of the number of classes is
used.}

\item{threshold}{\code{Numeric} scalar, threshold quantile which is used to 
identify mode clusters. Only kde densities above this values are kept and 
used to derieve mode cluster limits.}
}
\value{
\code{Numeric} matrix with lower and upper mode limits.
}
\description{
This function identifies the lower and upper limits within which robust 
end-members have clustered mode positions. It uses a kernel density estimate
of the mode positions of all input end-member loadings, clips it at a 
user-defined minimum density and returns the resulting rising and falling 
shoulders of the kde peaks as limits.
}
\details{
Note that the threshold above which a mode cluster is identified is an 
arbitrary, user-defined value and probably needs to be adjusted iteratively
to get reasonable results. The default value may or may not be adequate!
}
\examples{

## load example data set
data(example_EMpot)

## infer mode cluster limits
limits <- get.limits(loadings = EMpot)

}
\seealso{
\code{EMMA}, \code{model.EM}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
