% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unitList.R
\name{get_unitList}
\alias{get_unitList}
\title{get_unitList}
\usage{
get_unitList(x = NULL)
}
\arguments{
\item{x}{an emld object}
}
\value{
a list with two data.frames: "units", a table defining unit names, types, and conversions to SI,
and "unitTypes", defining the type of unit. For instance, the unit table could define "Hertz" as a unit
of unitType frequency, and the unitType define frequency as a type whose dimension is 1/time.
}
\description{
get_unitList
}
\details{
If no unitList is provided, the function reads in the eml-unitDictionary defining all standard
units and unitTypes.  This provides a convenient way to look up standard units and their EML-recognized names
when defining metadata, e.g. in the table passed to `set_attributes()`.
}
\examples{

# Read in additional units defined in a EML file
\donttest{
f <- system.file("tests", emld::eml_version(),
  "eml-datasetWithUnits.xml",
  package = "emld"
)
eml <- read_eml(f)
unitList <- get_unitList(eml)

## Read in the definitions of standard units:
get_unitList()
}

}
