% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_functions.R
\name{cond.prob}
\alias{cond.prob}
\title{Calculate conditional probabilities for observing records at each time point}
\usage{
cond.prob(x_mis,gamma,id,time)
}
\arguments{
\item{x_mis}{A matrix containing covariates for the missing data model. The first column should be all ones corresponding to the intercept.}

\item{gamma}{coefficients calculated from missing data model}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations in total for each subject}
}
\value{
a vector containing conditional probabilities.
}
\description{
A function calculates conditional probabilities for longitudinal missing data. The observing probability is at observation-level.
}
\examples{
## tests
# load data
data(wgeesimdata)
library(wgeesel)
data_wgee<-data.frame(do.call(cbind,wgeesimdata))
corstr<-"exchangeable"
dist<-"binomial"
id<-data_wgee$id
# obtain the estimates
fit<-wgee(y~x1+x2+x3,data_wgee,id,family=dist,corstr =corstr,scale = NULL,
         mismodel =obs_ind~x_mis1)
beta<-as.vector(summary(fit)$beta)
rho<-summary(fit)$corr
phi<-summary(fit)$phi
#calculate observing probabilies for all observations
gamma<-as.vector(summary(fit$mis_fit)$coefficients[,1])
x_mis<-wgeesimdata$x_mis
pi<-cond.prob(x_mis,gamma,id,time=3)

}
