% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSeasonLabel.R
\name{setSeasonLabel}
\alias{setSeasonLabel}
\title{Create a character variable that describes the period of analysis, when period of analysis has already been set in AnnualResults}
\usage{
setSeasonLabel(localAnnualResults, monthLab = 1)
}
\arguments{
\item{localAnnualResults}{data frame that contains the annual results, default is AnnualResults}

\item{monthLab}{object of monthLabel class, or numeric represented the short code, 
or character representing the descriptive name.}
}
\value{
periodName character which describes the period of analysis
}
\description{
The period of analysis can be of any length from 1 month to 12 months. 
The period of analysis can have any starting month from 1 (January) through 12 (December). 
This function produces a character character that describes this period of analysis. 
For example "water year", "calendar year", "year starting with April", or 
"Season consisting of April, May, June". 
There is an alternative version of this function for the case where AnnualResults does not exist. 
This might arise in a call from plotConcTime or plotLogConcTime. 
That function is called setSeasonLabelByUser.
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
AnnualResults <- setupYears(Daily)
setSeasonLabel(AnnualResults)

AnnualResultsWinter <- setupYears(Daily, 
                                  paLong = 3,
                                  paStart = 12)
setSeasonLabel(AnnualResultsWinter)
}
\keyword{graphics}
\keyword{quality}
\keyword{water}
